function y = group(x1,x2,x3,x4,x5,x6,x7,x8,x9,x10)
% GROUP Groups multiple values into a single vector.
%
% GROUP(X1,X2,...)
%   Xi - Matrices, vectors, strings or scalers.
% Returns a single row vector containing all Xi.
%
% EXAMPLE: m = rand(2,3);
%          v = 1:4;
%          s = 'hello';
%          p = group(m,v,s);
%
% SEE ALSO: ungroup

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

pos = 3+5*nargin;
s = zeros(nargin,5);
for i=1:nargin
  x = eval(sprintf('x%g',i));
  s(i,1) = pos;
  s(i,3:4) = size(x);
  s(i,2) = s(i,3)*s(i,4);
  s(i,5) = isstr(x);
  pos = pos + s(i,2);
end

y = zeros(1,pos-1);
y(1) = 12345.12345;
y(2) = nargin;
y(3:(5*nargin+2)) = reshape(s',1,5*nargin);
for i=1:nargin
  if s(i,5)
    y(s(i,1):(s(i,1)+s(i,2)-1)) = abs(reshape(eval(sprintf('x%g',i)),1,s(i,2)));
  else
    y(s(i,1):(s(i,1)+s(i,2)-1)) = reshape(eval(sprintf('x%g',i)),1,s(i,2));
  end
end
