function fuzdem40
%
% Utility Function : FUZDEM40
%
% Create a GUI for all of the examples included with the toolbox for 
% MATLAB 4.x versions

% Copyright (c) 1993 by PWS Publishing Company

title = 'Fuzzy Systems Toolbox Demonstrations';
figcolor = [128/255,128/255,128/255];
scrnsz = get(0,'screensize');
botm=scrnsz(4)-250;
f = figure('name',title,'numbertitle','off','pos',[10,botm,310,100],...
           'menubar','none','resize','off','color',figcolor,'vis','off');

demos = ['     Truck Backer     ';
         '  Inverted Pendulum   ';
         '  Number Recognition  '];

callbk = str2mat('trkdemo','pendemo','numdemo');

uicontrol('style','push','string','Close','pos',[15,5,280,20],...
          'horizontalalignment','center','callback','close');

for k=3:-1:1,
 str=demos(k,:);
 h=uicontrol('style','push','pos',[15,28+(3-k)*23,280,20],...
             'callback',callbk(k,:));
 set(h,'string',str);
end
drawnow;
set(f,'visible','on');

