function drawpnt(fig)
% DRAWPNT Given a figure handle, obtain points chosen by the user and
% store them in the 'userdata' property of FIG.  This function is
% used via the 'windowbuttondownfcn' property of the FIG.

% Copyright (c) 1993 by PWS Publishing Company

ax=get(fig,'currentaxes');
xlim = get(ax,'xlim'); ylim = get(ax,'ylim');
axmin = [xlim(1),ylim(1)];
axmax = [xlim(2),ylim(2)];
pt=get(ax,'currentpoint');
ln=get(ax,'userdata');

pts=get(fig,'userdata');
l1=[]; l2=[];

if all(pt(1,1:2)<axmax) & all(pt(1,1:2)>axmin),
 if ~length(pts),
  l1=line('xdata',pt(1,1),'ydata',pt(1,2),'linestyle','o','color','r','erase','xor');
 else
  lpts=length(pts(1,:));
  l1=line('xdata',[pt(1,1),pts(1,lpts)],'ydata',[pt(1,2),pts(2,lpts)],...
          'color','b','erase','xor');
  l2=line('xdata',pt(1,1),'ydata',pt(1,2),'linestyle','o','color','r','erase','xor');
 end
 pts=[pts,[pt(1,1);pt(1,2)]];
 ln=[ln,l1,l2];
 set(fig,'userdata',pts);
 set(ax,'userdata',ln);
end 
