function g=bump(s,v)
% BUMP Creates bump shaped fuzzy sets.
%
% BUMP(S,[A1,B1,C1,D1,E1; ...; An,Bn,Cn,Dn,En])
%   S  - Support (row) vector.
%   Ai - Left side for ith bump.
%   Bi - Left midway-point for ith bump.
%   Ci - Peak for ith grade vector.
%   Di - Right midway-point for ith bump.
%   Ei - Right side for ith bump.
% Returns matrix of n bump shaped grade vectors
%   defined over support vector S.
%
% EXAMPLE: s = 0:.1:10;
%          g = bump(s,[1 2 3 4 5]);
%          plotfs(s,'Bump Shaped Fuzzy Set');
%          plot(s,g);
%          hold off
%
% SEE ALSO: Bell, Flatbump, Rectangl, Trapzoid, Triangle

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[vr,vc] = size(v);
g = zeros(vr,length(s));

for i=1:vr
  a = v(i,1);
  b = v(i,2);
  c = v(i,3);
  d = v(i,4);
  e = v(i,5);

  up1 = find((s > a) & (s < b));
  up2 = find((s >= b) & (s <= c));
  down1 = find((s > c) & (s <= d));
  down2 = find((s > d) & (s < e));

  if length(up1), g(i,up1) = (1-cos((s(up1)-a)/(b-a)*pi*0.5))*0.5; end
  if length(up2), g(i,up2) = (sin((s(up2)-b)/(c-b)*pi*0.5) * 0.5 + 0.5); end
  if length(down1), g(i,down1) = cos((s(down1)-c)/(d-c)*pi*0.5)*0.5+0.5; end
  if length(down2), g(i,down2) = (1-sin((s(down2)-d)/(e-d)*pi*0.5))*0.5; end
end
