function y = andcomb(f,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10)
% ALLCOMB Apply function to all combinations of vectors elements.
%
% ALLCOMB('F',V1,V2,...Vz)
%   F  - Name of two operand function.
%   Vi - Nix1 column vectors.
% Returns (N1*N2*...*Nz)x1 column vector.
%
% ALLCOMB(F,M1,M2,...Mm)
%   Mi - NixM matrices of column vectors.
% Returns (N1*N2*...*Nz)xM matrix of column vectors.
%
% EXAMPLE: v1 = [0.1; 0.5; 0.7];
%          v2 = [0.9; 0.2];
%          v3 = allcomb('and',v1,v2)

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% without this line, MATLAB 3.5k thinks that 'x' is a file and quits
% with a 'Path not found error'
x = [];

y = x1;
[yr,yc] = size(y);
for i=2:(nargin-1)
  eval(sprintf('x = x%g;',i));
  [xr,xc] = size(x);
  a = table(1:yr,1:xr);
  y = feval(f,y(a(:,1),:),x(a(:,2),:));
  yr = yr*xr;
end
