/*
	infer3.h
	Header for General-Purpose Fuzzy Inference Library Ver. 3.0
	(c) 1991 Numata Ko~iti
*/

#include <stdio.h>

#define MAX_N_FUZZ_VAR		7
#define MAX_N_IN_VAR		4
#define MAX_N_RULE		27

#define RR_OK			0
#define RR_OVER_MAX		(-1)
#define RR_SHORT_FILE		(-2)
#define RR_SHORT_LINE		(-3)
#define RR_UNDEFINED_KEYWORD	(-4)
#define RR_UNDEFINED_SYMBOL	(-5)

typedef struct {
	float	Interval[MAX_N_IN_VAR + 1][2];
	float	Para[MAX_N_IN_VAR + 1][MAX_N_FUZZ_VAR][4];
	char	Switch[MAX_N_RULE];
	char	FuzzVarNo[MAX_N_RULE][MAX_N_IN_VAR + 1];
	int	nEqualPart, nFuzzVar[MAX_N_IN_VAR + 1], nInVar, nRule;
} FUZZ_INFO;

typedef struct {
	float		Interval[MAX_N_IN_VAR + 1][2];
	unsigned int	Para[MAX_N_IN_VAR + 1][MAX_N_FUZZ_VAR][4];
	char		Switch[MAX_N_RULE];
	char		FuzzVarNo[MAX_N_RULE][MAX_N_IN_VAR + 1];
	int		nEqualPart, nFuzzVar[MAX_N_IN_VAR + 1], nInVar, nRule;
} uFUZZ_INFO;

extern int ReadRule(FILE *fp, FUZZ_INFO *fzf);
extern float Infer(const float InVar[], const FUZZ_INFO *fzf);

extern int uReadRule(FILE *fp, uFUZZ_INFO *fzf);
extern float uInfer(const float InVar[], const uFUZZ_INFO *fzf);
