function tshow(x,c,sc)

%TSHOW(x)     
%         TSHOW(x,c,s) (trapezoid show) displays the fuzzy-figure 'x'.
%         'x' must be a non-discrete fuzzy-figure.
%         The optional parameter 'c' is a color-identifier (see COLID).
%         Parameter 's' is also optional; if s=1 then there is an auto-
%         scaling in the graphics-screen.

%    Stephan Molt 01-09-93

[z,s]=size(x);
% pruefen der argumente
if(nargin>3)
   error('wrong number of arguments - TSHOW requires up to three arguments')
end
if (s==4),
   [n,m,alpha,beta]=copy4(x);
   ymax=1;
elseif (s==5),
   [n,m,alpha,beta,ymax]=copy5(x);
else, 
   error('fuzzy-figure must have either 4 or 5 columns; do not use a discrete figure')
end

% bereich berechnen
ber=alpha+beta;
x0=n-2*ber;
x1=m+2*ber;

if(nargin<3)
    sc=0;
end

% falls automatische skalierung verwendet wird: achsen berechnen
if (sc==1)
 scale=[x0,x1,0,ymax*1.5];
%  scale ist der Vektor, der Achsen skaliert
 axis(scale);
 hold on;
end
col='-r';

if(nargin>1)
   col=colid(c);
end

k1=[x0,n-alpha,n,m,m+beta,x1];
k2=[0,0,ymax,ymax,0,0];

plot(k1,k2,col)

return



%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
