function ruledef(button)

%         This is a GUI-Utility function
%         einlesen von rule, n_in
%         ruledef wird von designrule aufgerufen (indirekt)

load f__temp;
sd=setdesc;

% entsprechend des gedrueckten buttons muss festgestelt werden, um welches
% objekt es sich handelt

text_pos=floor( (button+1)/2);

% herausfinden, ob '+' oder '-' angewaehlt wurde
if floor(button/2)==button/2
   % gerade --> negativ
   summ=-1; 
else
   % ungerade --> positiv
   summ=+1;
end

% zyklisch: ist man an einer grenze, laeuft man zyklisch durch
% bsp: obere grenze und '+' gedrueckt -> geht auf untere grenze

if text_pos <= n_in
   spalte=1;
   zeile=text_pos; 
   max_elem=sd(text_pos,1);   
else
   spalte=2;
   zeile=text_pos-n_in;
   max_elem=sd(zeile,4);
end

element=rule(zeile,spalte);

if (element==max_elem & summ==+1)
   element=0; 
elseif element==0 & summ==-1
   element=max_elem;
else
   element=element+summ;
end

% bereitstellen der linguistischen variable, die zu dieser zahl in der
% regelamtrix gehoert
lingvar=lingus(max_elem);
string2=[];
setstr(string2);

if element==0
   string2='ANY';
else
   string2=lingvar(element,1:3);
end

set(h(text_pos),'string',string2);

rule(zeile,spalte)=element;

save f__temp h n_in rule setdesc nr;

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE


