function [rule]=editrule(rule,set,setdesc,rule_nr)

%EDITRULE
%         [rule]=EDITRULE(rule,set,setdesc,rule_nr) is a subroutine
%         to edit the rules of an alreay dsigned fuzzy-control-system. 
%         'set' is a matrix of type SET and 'setdesc' is the set-descrip-
%         tion-matrix; to obtain those matrices use the MAKESET- and the 
%         OUTDEF-command. 
%         'rule' contains the already designed rules of the fuzzy-con-
%         troller and 'rule_nr' is the number of the rule you want to
%         change. 
%         If you want to add a completely new rule, call EDITRULE and 
%         assign 'rule_nr ' a negative value.
%
%         See also MAKESET, INDEF, OUTDEF, RULES

% Stephan Molt 01-09-93

if (nargin<3)
   error('wrong number of arguments - EDITRULE requires at least three arguments');

% pruefen der argumente; bei drei argumenten wird nach rule_nr gefragt

elseif (nargin==3)
   [zeil,spalt]=size(rule); 
   max_rule=spalt/3;
   txt=['There are ',num2str(max_rule),' rules'];
   disp(txt);
   k=input('Which one do you want to change [0 for new rule]');
   if (k>max_rule)
       error('This rule does not exist');
   end
   if (k<=0)
      rule_nr=-1;
   end   
   rule_nr=k;
end

% pruefen, ob objekte vom richtigen datentyp sind
[zeil,spalt]=size(rule);
[zz1,ss1]=size(set);
if(ss1~=48)
  error('the second argument must be of type SET');
end
max_rule=spalt/3;
n_in=abs(set(1,1));
n_out=abs(set(1,21));
st=rule_nr*3-2;
en=rule_nr*3;


% zu aendernde regel herausfiltern
if(rule_nr>0)
  if(rule_nr<=max_rule) 

     vor=rule(1:zeil,1:st-1);
     insert=rule(1:zeil,st:en);    % insert ist zu aendernde regel
     nach=rule(1:zeil,en+1:spalt);
     save f__temp3 vor nach 
     makerule3(insert,set,setdesc,rule_nr);
     
  else
     error('rule-index exceeds the maximum number of rules')
  end
  k=input('Press any key to update your rules','s');
  load f__temp
  insert=rule
  load f__safe
  insert(1,3)=c__s;
  load f__temp3
  rule=[vor,insert,nach];

else
  % in diesem zweig wird neue regel erstellt
  insert=init2(n_in,n_out);
  vor=rule;
  nach=[];
  save f__temp3 vor nach 
  makerule3(insert,set,setdesc,max_rule+1);

  k=input('Press any key to add your new rule','s');
  load f__temp
  insert=rule;
  load f__safe
  insert(1,3)=c__s;

  load f__temp3
  rule=[vor,insert,nach];

  
end


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

