function dshow(x,d_step,c,sc)

%DSHOW(xd)
%         DSHOW(xd,d_step,c,sc) (discrete show) displays the discrete 
%         fuzzy-figure 'xd'. 'xd' must be discrete, i.e. the user must 
%         build the corresponding discrete figure (by using DISCRET) be-
%         fore calling DSHOW.
%         'd_step' is the discret-step variable (see DISCRET).
%         The colour-identifier 'c' is an optional argument.
%         The parameter 'sc' is also optional: if sc=1 then there is an 
%         auto-scaling of the graph; for any other value of 'sc' or if 
%         'sc' isn't set at all then there is no scaling.	
%
%         See also COLID, DISCRET

% Stephan Molt 01-09-93

[z,s]=size(x);

% pruefen der argumente
if (s<6) 
   error('fuzzy-figure must be discrete; use DISCRET before using DSHOW')
end
col=1;

if(nargin>4)
  error('wrong number of arguments - DSHOW requires less than four arguments')
end

if(nargin>=3)
   col=c;
end
t=colid(col);

start=x(1);
ende=x(2);

% hier ist autoscale -> achsen werden skaliert
if (nargin==4)
  if(start<0)
    auto1=start*1.1;
  else
    auto1=start*0.9;
  end
  if(ende>0)
    auto2=ende*1.1;
  else
    auto2=ende*0.9;
  end
  axis([auto1,auto2,0,2]);
end

% erste zwei komponenten fallen weg, da sie start und ziel angeben
for i=3:1:s
    mu=[mu,x(i)];
    k=[k,start+(i-3)*d_step];
end

plot(k,mu,t)	


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

