function xdot = f__deq(t,x)
%f__deg
%        xdot = f__deq(t,x)
%        RHS-function for state integration
%        Here you find the (nonlinear) system of differential eq.
%
%	
%
%        state-vector:      x(1) = U
%                           x(2) = W
%                           x(3) = Q
%                           x(4) = Theta
%
%	
%  OUTPUT
%        xdot  : state-derivative
%

% B. Kaempf 12.3.93

 deltah = 0 ;

load uuu
 deltav=u;
 eta = 0   ;
 delhdot = 0;

 T =68;   	% Schub = 100 N , ausreichend fuer Uo=14 m/s = 50.3 km/h
	
 D= 0.48 ;	% Drehimpuls Propeller = 100 
 g = 9.81 ;	% Erdbeschleunigung = 9.81 m/s^2
 k1 = 0.08;	% zusaetzliche Massen nach Munk
 k2 = 0.85;
 k3 = 0.6;
 V = 109 ;
 l =16 ;
 rho = 1.21;
 m = 117.3;
 ms= 94.4;
 Ixx = 301;
 Iyy = 1973.3 ;
 Izz = 1770 ;
 Ixz = 148.4;
 rho = 1.21 ;     % Daten fuer Momentenberechnung
 lx = 8.5 ;
 lz = 0.455 ;
 S = 2*3.08 ;
 ln = 6.23;

 k1 = k1+1;
 k2 = k2+1;
 k3 = k3+1;
 Iyy = k3*Iyy;
 Izz = k3*Izz;

 l=16;
 U0=11;
 f1=l/(2*U0);
 f2=l*l/(2*U0*U0);



 c_z_alphadot = -0.9859*f1     ;
 c_z_q        =  0.3415*f1     ;
 c_m_alphadot = -0.0292*f1     ;
 c_m_q        = -0.2290*f1     ;
 c_m_qdot     = -0.0992*f2     ;
 c_z_eta      = -2.29 ;
 c_m_eta      = -2.29 ;

K1 = 0.5* rho * (x(1)*x(1)+(x(2)+w__st)*(x(2)+w__st)) * V^(2/3);
K2 = 0.5* rho * (x(1)*x(1)+(x(2)+w__st)*(x(2)+w__st)) * V^(2/3) * l ; 
K3 = 0.5* rho * (x(1)*x(1)+(x(2)+w__st)*(x(2)+w__st)) * S;
K4 = K3*ln;
 
xdot=zeros(4,1);

alpha = (x(2)+w__st)/x(1) ;

[cx,cz,cm]=beiwlong(alpha);           % Compute the aerodynamical coeff
				      % This m.file is not shipped with
				      % the fuzzy-toolbox !!!!!!!!


xdot(1) = 1/(k1*m)*(K1*cx+T*cos(deltav))-x(3)*x(2) ;

xdot(2) = 1/(k2*m-K1/x(1)*c_z_alphadot) * ( K1*cz...
        + K1 * c_z_q * x(3)  + K3*c_z_eta*eta  -T*sin(deltav)...
        + k2*m*x(1)*x(3) ) ;

xdot(3) = 1/(Iyy-K2*c_m_qdot) * (K2*cm + K2/x(1)*c_m_alphadot...
        *xdot(2) + K2*c_m_q * x(3) + K4*c_m_eta*eta... 
        - ms*g*lz*sin(x(4)) - T*lx*sin(deltav) ) ;

xdot(4) = x(3);
