function u=f__fc(rule,sd,set,Rs,Sp,y)

%f_fc
%         u=f__fc(rule,sd,set,Rs,Sp,y)
%         f__fc (f_FuzzyController) calculates the output of the
%         fuzzy controller in terms of the measured vector y

% B.Kaempf 12.6.93


% prepare input parameters for fuzzy control routines
% ---------------------------------------------------

% matrix of measured vetor y: each element of vector y is a fuzzy-figure
% for each element of y, you have to specifie the uncertainty of the
% measure:
% e.g. : [y(1), 0.1, 0.2]  where 0.1 means the "fuzzyness" in percent (10%)
%                          of the input-value y(1)
Mm=[y(1), 0.1, 0.1          % -> y(1) +/- 10%
    y(2), 0.1, 0.1];        % -> y(2) +/- 10%
  

nr_in=abs(set(1,1));
max_sd=max( [sd(:,1);sd(:,4)] );

% fuzzy-controller
% ----------------

Am=analyse(nr_in,max_sd,sd,Mm,1);
[Aij,Aj]=evaluate(Am,rule,sd,1);

% u is the output of the fuzzy-controller
u=unfuzzy2(Rs,Sp,Aj);


% if you want to use the defuzzy1-function to defuzzy your value u (the output
% of the fuzzy-controller) you have to remove the line
%
%	delta=unfuzzy2(Rs,Sp,Aj)
% 
% and replace it by the following two lines:
%
%	u_d=inferenz(Aj,rule,infop,nrout,sd,dstep,or_op)
%	u=unfuzzy1(u_d,dstep)
%
% in the above line, where u_d is calculated Aj, rule, sd are parameters;
% you have to assign values to the others:
%
%	infop (inference-operator): 2,3
%	nrout (number of output-variables; here 1)
%	dstep (discrete steps: depending on the range of the variable;
%             mainly a value of 1 is used)
%	or_op (fuzzy-or relation) : 1-6


