function [f]=trapeze(x,s,t,c)
%TRAPEZE:  Membership function for matrix X will be drawn using a 
%          trapezoidal shape.
%
%                            [Y]=TRAPEZE(X,a,b,c)
%
%          Where a, b and c are slope, flatness and center of trapezoidal.
%          Defaults value for c and b and a are 0, 0 and 1 respectively.
%
%                          See also BELL_1, BELL_2, SIGMOID, and MF_PANEL.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin < 4,c=0;end
if nargin < 3,t=0;end
if nargin < 2,s=1;end

if s == 0 , s=eps; end

z=c+t/2+1/s;
y=c-t/2-1/s;

[m,n]=size(x);


for i=1:m
for j=1:n

if x(i,j) >= z | x(i,j) <= y
    f(i,j) = 0 ;
elseif x(i,j) < c+t/2 & x(i,j) > c-t/2
    f(i,j) = 1 ;
elseif x(i,j) > c
    f(i,j) = s*(z-x(i,j));
else
    f(i,j) = s*(x(i,j)-y);
end

end %for j
end %for i
