function [xq]=quantize(x,q)
%QUANTIZE: To quantize the input matrix X with a quantum size Q, this
%	   function can be utilized. (Xq=X+Q/2)
%
%		           Xq=QUANTIZE(X,Q)

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if q < 0
	error('Quantum size Q can not be less than zero.');
elseif q == 0
	xq=x;
else
	xq=q .* round(x ./ q);
end
