function mfplot(a,b,c,d,e,f,g,h,i,j)
%MFPLOT: To plot the membership functions defined on a fuzzy matrix of 
%	 fuzzy value  A over universe U, or more general, to plot the
%	 rules given for a rule base with maximum 4 input and one output
%	 this command can be used.
%
% 			   	MFPLOT(A,U)
%  			 	MFPLOT(A,U,B,V)
%				MFPLOT(A1,U1,...,A4,U4,B,V)
%
%	 It is to be noted that the maximum number of rules can't exceed
%	 9 rules.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

clg;
set(gcf,'units','normal','position',[.34 .35 .65 .60]);

drawnow

if nargin == 2
[n_rule,n_quant]=size(a);
        for n_ind = 1:n_rule,
	        subplot(n_rule,1,n_ind);
	       	plot(b,a(n_ind,:));
        end

elseif nargin == 4
[n_rule,n_quant]=size(a);
        for n_ind = 1:2:2*n_rule,
	        subplot(n_rule,2,n_ind);
	        plot(b,a(n_ind/2+.5,:));
        end
        for n_ind = 2:2:2*n_rule,
	        subplot(n_rule,2,n_ind);
	        plot(d,c(n_ind/2,:),'r');
        end

elseif nargin == 6
[n_rule,n_quant]=size(a);
        for n_ind = 1:3:3*n_rule,
	        subplot(n_rule,3,n_ind);
	        plot(b,a(n_ind/3+.7,:));
        end
        for n_ind = 2:3:3*n_rule,
	        subplot(n_rule,3,n_ind);
	        plot(d,c(n_ind/3+.4,:),'r');
        end
        for n_ind = 3:3:3*n_rule,
	        subplot(n_rule,3,n_ind);
	        plot(f,e(n_ind/3,:),'g');
        end

elseif nargin == 8
[n_rule,n_quant]=size(a);
        for n_ind = 1:4:4*n_rule,
	        subplot(n_rule,4,n_ind);
	        plot(b,a(n_ind/4+.75,:));
        end
        for n_ind = 2:4:4*n_rule,
	        subplot(n_rule,4,n_ind);
	        plot(d,c(n_ind/4+.5,:),'r');
        end
        for n_ind = 3:4:4*n_rule,
	        subplot(n_rule,4,n_ind);
	        plot(f,e(n_ind/4+.25,:),'g');
        end
        for n_ind = 4:4:4*n_rule,
	        subplot(n_rule,4,n_ind);
	        plot(h,g(n_ind/4,:),'w');
        end

elseif nargin == 10
[n_rule,n_quant]=size(a);
        for n_ind = 1:5:5*n_rule,
	        subplot(n_rule,5,n_ind);
	        plot(b,a(n_ind/5+.8,:));
        end
        for n_ind = 2:5:5*n_rule,
	        subplot(n_rule,5,n_ind);
	        plot(d,c(n_ind/5+.6,:),'r');
        end
        for n_ind = 3:5:5*n_rule,
	        subplot(n_rule,5,n_ind);
	        plot(f,e(n_ind/5+.4,:),'g');
        end
        for n_ind = 4:5:5*n_rule,
	        subplot(n_rule,5,n_ind);
	        plot(h,g(n_ind/5+.2,:),'w');
        end
	for n_ind = 5:5:5*n_rule,
	        subplot(n_rule,5,n_ind);
	        plot(j,i(n_ind/5,:),'b');
        end

else
        error('Inputs argument is not correct')
end
cl_close_axes=axes('units','normal','position',[0 0 1 1],'visible','off');

% closing window push button
cl_close_text = uicontrol(gcf,...
	'style','frame','units','normal',...
	'position',[.695 .015 .21 .055]);
cl_close = uicontrol(gcf,...
	'style','push','units','normal',...
	'string','Close Window','fore','r',...
	'position',[.70 .02 .20 .045],...
	'callback','close(gcf)');
text(.12,.05,['Membership Function for ' num2str(n_rule) ' rules']);
