function [dbp,W]=kosko(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p)
% KOSKO:  When the inputs of fuzzy inference systems are crisp rather than
%	  fuzzy value, decision process becomes simpler. This function 
%	  perform the Kosko's mechanism.
%         		[Bo,W] = KOSKO(A,Ao,U,B,V,MISC)   
%	  Where A and B are matrix of antecedent and consequent respectively
%	  ,Ao is input crisp value, U is the input universe and V is the
%	  output universe. The miselanious input MISC can be 1 or 2. if it 
%	  is 1, the output crisp value Bo is as follow; 
%          	Bo=sum(W*Integral(B)*Centre(B)) / sum(W*Integral(B))
%         In the case MISC is 2 the output will be computed as;
%          		Bo=sum(W*Centre(B)) / sum(W)
%	  The second output W gives the firing weigthe for each rule.
%         When premise contains more then one antecedent, Considering
%         liaison operator AND is important. Therefore if AND is 1, then
%         the minimum of two weight selected as overall weight of firing
%         and when it is 2 the multiplication considered. 
%
%         [Bp,W] = KOSKO(A1,A1o,U1,...,A4,A4o,U4,B,V,AND,MISC)
%
%         See also INTEGRAL, CENTRE, LARSEN, SUGENO, ZADEH, and MAMDANI.


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

if nargin ==  6

	W=grademf(a,b,c);db=d;dv=e;misc=f;

elseif nargin == 10

	W1=grademf(a,b,c); W2=grademf(d,e,f);
        if i == 1,
        	W=min(W1,W2);
        elseif i == 2
        	W=W1 .*W2;
        else
        	error('Liasing operator AND is not proper method.')
        end

	db=g;dv=h;misc=j;

elseif nargin == 13

	W1=grademf(a,b,c); W2=grademf(d,e,f); W3=grademf(g,h,i);
	db=j;dv=k;misc=m;

        if l == 1,
        	W=min([W1,W2,W3])';
        elseif l == 2
        	W=W1 .*W2 .*W3;
        else
        	error('Liasing operator AND is not proper method.')
        end

elseif nargin == 16

	W1=grademf(a,b,c); W2=grademf(d,e,f); W3=grademf(g,h,i);W4=grademf(j,k,l);
	db=m;dv=n;misc=p;

        if o == 1,
        	W=min([W1,W2,W3,W4])';
        elseif o == 2
        	W=W1 .*W2 .*W3 .*W4;
        else
        	error('Liasing operator AND is not proper method.')
        end



else
	error('Input arguments are not sufficient.');
end

if W == 0,
   disp(blanks(2)'); disp('Warning: No rule fired!');
end;

% truncation process/ musk

if misc == 1
	int=integral(db,dv);
	cen=centre(db,dv);
	dbp= (sum(W .* cen .* int)) / (sum(W .* int));
elseif misc == 2
        cen=centre(db,dv);
        dbp= (sum(W .* cen)) / sum(W);
else
	error('Connector operator MISC is not a proper method.')
end
