function [xdot] = invpend(x,F)
%INVPEND:  The nonlinear model for inverted pendulum with the parameters
%          given in Mp(mass of pole),Lp(half-length of pole),Mc(mass
%          of cart) will be returned.
%
%                             [X_DOT] = INVPEND(X,F)
%
%          Where F is input forces, and state vector X is defined as 
%          X(t)=[Z(t) Z_DOT(t) THETA(t) THETA_DOT(t)]'
%
%          Z(t):  position of cart
%          Z_DOT(t): velocity of cart
%          THETA(t):  angular position of pole (Degree) 
%          THETA_DOT(t): angular velocity of pole
%
%	   Note: The Parameters of inverted pendulum are fixed for
% 	   Mp=.1 kg, Mc=1 kg, Lp=.5 m. They can be changed with editing 
% 	   the file. 

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 15-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.


%PARA=[Mp Mc Lp]
g=9.81;para=[.1 1 .5];

x(3)=x(3)*pi/180;
x(4)=x(4)*pi/180;

m=para(1);M=para(2);l=para(3);
sx=sin(x(3));cx=cos(x(3));x=x(:);


xdot(4)=(g*sx+cx*(-F-m*l*(x(4)^2)*sx)/(M+m))/(l*((4/3)-((m*cx*cx)/(M+m))));

xdot(3)=x(4);

xdot(2)=(F+m*l*(x(4)*x(4)*sx-xdot(4)*cx))/(M+m);

xdot(1)=x(2);

xdot=xdot(:);

xdot(3)=xdot(3)*180/pi;
xdot(4)=xdot(4)*180/pi;
