function [ap] = fzfir(n,u,a,b,c)
%FZFIR  The operation fuzzification has the effect of  transforming
%       a classical set/crisp value Ao into a fuzzy set Ap. The fuzzifier
%       developed in this function can handle five different types of 
%	membership function for crisp value Ao. The universe must be
% 	expressed an a ascending vector U. 
%
%           [Ap] = FZFIR(1,U,a,b,Ao)  ..........  bell_1.m
%           [Ap] = FZFIR(2,U,a,b,Ao)  ..........  bell_2.m
%           [Ap] = FZFIR(3,U,s,t,Ao)  ..........  trapeze.m
%           [Ap] = FZFIR(4,U,a,0,Ao)  ..........  sigmoid.m
%           [Ap] = FZFIR(5,U,0,0,Ao)  ..........  fuzzy singleton
%
%	The third and forth input variables are parameters of related
%	membership function. 
%
%		See also BELL_1, BELL_2, TRAPEZE, SIGMOID, and DEFZFIR.

% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.

% Checking the inputs of function

u=u(:)';

if n == 1,
        ap=bell_1(u,a,b,c);
elseif n == 2,
        ap=bell_2(u,a,b,c);
elseif n == 3,
        ap=trapeze(u,a,b,c);
elseif n == 4
        ap=sigmoid(u,a,c);
else

        ap=zeros(size(u));
        ap(max(find(abs(u-c) == min(abs(u-c))))) = 1;
end
