REM Paper, Scissors, Rock
REM AI Expert's AI Apprentice, February 1991


DECLARE SUB choose (m$)
DEFINT A-Z
hist$ = ""
htot = 0
ctot = 0
PRINT "Welcome to Paper, Scissor, Rock.  As in the real game, you must choose"
PRINT "to play Paper, Scissor, or Rock at each game round.  I will do the same."
PRINT "Then we compare our plays.  Paper beats rock, rock beats scissor, "
PRINT "and scissor beats paper."
PRINT
i$ = ""
WHILE i$ <> "q"
  CALL choose(m$)
  i$ = ""
  WHILE i$ = "" OR INSTR("psrq", i$) = 0
    INPUT "What do you choose, paper, scissor, rock, or quit"; a$
    i$ = LCASE$(LEFT$(a$, 1))
  WEND
  PRINT "While you were choosing, I chose ";
  IF m$ = "p" THEN PRINT "paper."
  IF m$ = "r" THEN PRINT "rock."
  IF m$ = "s" THEN PRINT "scissors."

  ' update the history
  hist$ = hist$ + UCASE$(m$) + i$'computer in uppercase to ease search
  ' score it
  x$ = i$ + m$
  IF i$ = "q" THEN
    PRINT "Thank you for playing.  The final score was:"
    PRINT "Your wins:"; htot; ".  My wins:"; ctot; "."
  ELSE
    IF i$ = m$ THEN
      PRINT "A tie."
    ELSE
      IF x$ = "sp" OR x$ = "pr" OR x$ = "rs" THEN
        htot = htot + 1
        PRINT "You win!"
      ELSE
        ctot = ctot + 1
        PRINT "I win!"
      END IF
    END IF
  END IF
WEND

SUB choose (m$) STATIC
SHARED hist$
'initialize totals
true = -1: false = NOT true
p = 0
r = 0
s = 0
' figure out what he's going to do, put it in o$
done = false
depth = 1
l = LEN(hist$)
WHILE NOT done
'take the last opponent move, add it to the search list, trim from list of
'previous opponent moves.  We'll add a move at a time, alternating between
'human and computer, until we find a no match, then we'll take the most
'specific case and assume that the human will repeat it.
'
  IF depth <= l THEN
    srch$ = RIGHT$(hist$, depth)
    'now find out how many matches we have, and what the responses were
    i = 1
    matches = 0: pt = 0: rt = 0: st = 0'totals
    allmatchesfound = false
    
    WHILE NOT allmatchesfound
      x = INSTR(i, hist$, srch$)
      IF (x > 0) AND (x <> l - depth + 1) THEN
        matches = matches + 1
        IF LEN(srch$) MOD 2 = 0 THEN inc = 2 ELSE inc = 1
        n$ = MID$(hist$, x + depth + 1, 1)
        IF n$ = "p" THEN pt = pt + 1 ELSE IF n$ = "s" THEN st = st + 1 ELSE IF n$ = "r" THEN rt = rt + 1 ELSE PRINT "Error: don't recognize "; n$
        i = x + 1 'start one character over for search
      ELSE
        allmatchesfound = true
      END IF
    WEND
    ' did we find anything?
    IF pt + st + rt = 0 THEN
      done = true
    ELSE
      depth = depth + 1
      p = pt: s = st: r = rt
    END IF
  ELSE
    done = true   '       we've exhausted the history.
  END IF
WEND

IF r = 0 AND s = 0 AND p = 0 THEN
  o$ = "s"'dumb guess
  IF RND(99) > .5 THEN o$ = "p"
  IF RND(99) > .5 THEN o$ = "r"
'  PRINT "Random guess"
ELSE
  IF r >= s AND r >= p THEN o$ = "r" ELSE IF p >= s AND p >= r THEN o$ = "p" ELSE o$ = "s"
END IF
'respond to expected move
IF o$ = "p" THEN m$ = "s" ELSE IF o$ = "r" THEN m$ = "p" ELSE m$ = "r"
END SUB


