

# ==========================================================================
#
#   MAKE file to create net.exe  -
#
# ==========================================================================
#
#  Instructions:
#         C>make net.mak
#
# ==========================================================================
#
#   History:
#
#     10 dec 89  rk   created file
#
# ==========================================================================
#
#    Macros:
#
# ==========================================================================
#
#   Directory Macros:
#

# Rodger's directories
  net_DIR    =  c:\bnet
  ARITY_DIR     =  c:\Arity510
  PLINK86_DIR   =  c:\util
  LIB_DIR       =  c:\library

# --------------------------------------------------------------------------
#
#   Other Macros:
#

PC            =   $(ARITY_DIR)\APC

PC_FLAGS      =    ,, net

CLONER        =   $(ARITY_DIR)\clone

LINKER        =   $(PLINK86_DIR)\plink86

LINKER_FLAGS  =   VERBOSE

MA_FLAGS      =    ;


# ==========================================================================
#
#   Object Module Macros:
#
# =========================================================================
# ============================  root ( code ) segment  ====================


ROOT_OBJS =  net.obj exec.obj


# =========================================================================
# ============================  main_seg      segment  ====================


MAIN_SEG_OBJS  =     newtrace.obj tracehlp.obj


# ==========================================================================
#
#  Create Prolog object modules:
#
# --------------------------------------------------------------------------
#
#   Main Prolog source module:
#
# --------------------------------------------------------------------------


net.obj:     net.ari
    erase       *.obj
    erase       net.idb
    erase       net.exe
    erase       *.ovl
    $(CLONER)   main_seg
    $(PC)       net.ari  ,, net/n
    dir         net.*


# ==========================================================================
#
#   Create object modules for the net modules:
#

# top level of stand-alone net
net.OBJ:       $(net_DIR)\net.ari
    $(PC)         $(net_DIR)\net.ari     $(PC_FLAGS)

# top level of stand-alone net

exec.OBJ:       $(net_DIR)\exec.ari
    $(PC)         $(net_DIR)\exec.ari     $(PC_FLAGS)


# trace
NEWTRACE.OBJ:     $(LIB_DIR)\NEWTRACE.ari
    $(PC)         $(LIB_DIR)\NEWTRACE.ari   $(PC_FLAGS)


tracehlp.OBJ:      $(LIB_DIR)\tracehlp.ari
    $(PC)         $(LIB_DIR)\tracehlp.ari   $(PC_FLAGS)



# ==========================================================================
#
#  Create net.EXE:
#


net.exe:    net.mak         net.lnk         $(ROOT_OBJS)       \
               $(MAIN_SEG_OBJS)
   $(LINKER)   @net.lnk        $(LINKER_FLAGS)
   dir          net.*


# ==========================================================================


