; Code for AUBREY

; written for Microsoft LISP/muLISP 86


; by David Hillman, September  1989

; Enjoy and use this--and if you would like ...please consider
; donating something to the real-life Aubrey Education fund
; care of:
;	Aubrey Hillman
;	25912 LaSalle Ct.
;	Damascus, MD 20872
;				Thank You


; NOTE :
; At approximately line 996 you will find the (rds) statement
; the code following this is the test knowledge base, it should
; be removed to a separate file for execution


; this is a portion of the total code I have developed, you may add
; functions as you see fit.

; I have not included the data base, array, date, form, and help functions
; however, with a little imagination, you can create your own

; to load the following you need muLISP 86 (I have not tried this
; with muLISP 87-so no guarantees), this may also be compatible with some
; other versions of LISP (again no guarantees-we all know how standardized
; can be!!!)

; a file AUBREY.SYS will be saved which can be loaded for future use

; at the $ prompt, type (driver)

; this will start the program, enter the name of the knowledge base file

; the following were used to provide some degree of Common lisp
; compatibility

(MOVD '< 'LT)
(MOVD '<= 'LE)
(MOVD '> 'GT)
(MOVD '>= 'GE)
(MOVD 'NUMBERP 'NUMP)

; this ensures that no knowledge base is loaded

(setq kbloaded nil)

; this is the interpreters driver to run the program

(defun driver ()
   (setq newtype nil)
   (cond ((eq kbloaded nil)
        (getkb)) )
   (nsc 'a)
   (runkb)
   (reset-screen)
   (end-session) )


(defun end-session ()
   (make-window 0 0 25 80)
   (foreground-color 7)
   (background-color 0)
   (clear-screen)
   (system) )

; screen handling functions

(defun reset-screen ()
   (make-window 0 0 25 80)
   (clear-screen) )

(setq *keyint '"*")
(setq *keyint-sym '*)

(setq endtext-string
   "        F2=EXPLAIN F3=ATTRIBUTES F4=SUPPORT <RET> TO CONTINUE")

(setq end-return     "    ENTER <RET> TO CONTINUE  ")
(setq q-return "ENTER RESPONSE THEN <RET> OR *<RET> FOR UTILITIES")
(setq d-text "PRESS <RET> BETWEEN EACH PART OF DATE ENTRY")


; the following sets the various screen functions for an IBM PC/compatible
; if not running on a "true" compatible, try disabling this

(defun nsc (type)
   (clear-screen)
   (cond ((neq newtype type)
        (cond ((eq type 'a)
             (nscreen 0 0 25 80 fcol bcol))
              ((eq type 'q)
             (nscreen 7 0 4 80 fcol bcol)
             (princ q-return)
             (nscreen 0 0 7 80 fcol bcol))
              ((eq type 'm)
             (nscreen 18 0 4 80 fcol bcol)
             (princ q-return)
             (nscreen 0 0 18 80))
              ((eq type 'd)
             (nscreen 7 0 4 80 fcol bcol)
             (princ d-text)
             (nscreen 0 0 7 80 fcol bcol))
              ((eq type 'u)
             (nscreen 0 0 24 75 fcol bcol))
              ((eq type 's)
             (nscreen 5 30 15 45 fcol bcol) ) ) ))
   (setq newtype type) )

; this sets up  the screens

(defun nscreen (nrow ncol nrows ncols forecolor backcolor)
   (foreground-color forecolor)
   (background-color backcolor)
   (make-window nrow ncol nrows ncols)
   (clear-screen)
   (draw (sub1 ncols) (sub1 nrows))
   (make-window (add1 nrow) (add1 ncol) (- nrows 3) (- ncols 3) ) ]


; this actually puts the lines on for the function before

(defun draw (length height)
   (setq length (- length 2))
   (princ (ascii 218))
   (setq top length)
   (loop ((zerop top))
        (princ (ascii 196))
        (setq top (sub1 top)) )
   (princ (ascii 191))
   (terpri)
   (setq current-row (row))
   (loop ((eq current-row height))
        (princ (ascii 179))
        (set-cursor current-row (add1 length))
        (princ (ascii 179))
        (terpri)
        (setq current-row (row))  )
   (princ (ascii 192))
   (loop ((zerop length))
        (princ (ascii 196))
        (setq length (sub1 length)) )
   (princ (ascii 217))   ]

; this looks for a function key

(defun getfun ()
   (clear-input)
   (setq *fkey* nil)
   (setq read-char nil)
   (setq *fkey* (read-byte))
   ((eq *fkey* 255)
    (setq *fkey* (read-byte))
    (setq read-char T)
    (return *fkey*) )
   (setq read-char T)
   (return nil) )

; reads numbers

(defun readnum ()
    (clear-input)
    (setq *nrow (row) *ncol (column))
    (setq *rnum (read))
    (cond ((or (numberp *rnum) (eq *rnum *keyint-sym))
        (return *rnum))
          (T (set-cursor *nrow *ncol)
        (princ "    ")
        (set-cursor *nrow *ncol)
        (readnum)) )  )

; reads in text strings on a new line

(defun readstring ()
   (clear-input)
   (terpri)
   (read-line))

; reads in symbols for yes/no assertions

(defun readassert ()
   (clear-input)
   (read-char))

(defun readsymbol ()
   (clear-input)
   (read) )


; the following outputs text to the screen, file, and printer
; strings are output as "xxxxxxxxx"
; attributes are output as val <attributename>
; hard returns are output as !
; syntax is :
; (advise (<tofile> | <toprint>
; "<text>"  ! val <attributename>" )

(defun advise (text)
   (setq screenprint T)
   (setq holdadvise text)
   (setq test-text text)
        (loop ((null test-text) )
          (cond ((eq (car test-text) 'val)
              (pop test-text)
              (cond ((eq (get (car test-text) 'known) nil)
                  (eval-kb (pop test-text) nil nil) )
                 ((eq (get (car test-text) 'known) T)
                  (pop test-text) ) ) )
             ((neq (car test-text) 'val)
                (pop test-text) ) ) )
   (setq outfile nil)
   (setq outprint nil)
   (cond ((eq (car text) 'tofile)
        (pop text)
        (setq outfilename (car text))
        (cond ((eq (get outfilename 'anattr) T)
             (eval-kb outfilename)
             (setq outfilename (get outfilename 'value)) ) )
        (pop text)
        (setq outfile T)
        (setq screenprint nil)
                (cond ((eq (car text) 'new)
             (pop text)
             (wrs outfilename)
             (writeptr 0) )
              ((eq (car text) 'old)
             (pop text)
             (wrs outfilename T)
             (writeptr (sub1 (writeptr 'eof))) ) ) )
         ((eq (car text) 'toprint)
        (setq screenprint nil)
        (setq outprint T)
        (pop text)
        (setq wrs print) )
         ((eq (car text) 'screen)
        (pop text)
        (setq *row (pop     text))
        (setq *col (pop     text))
        (setq *numrow (pop text))
        (setq *numcol (pop text))
                (nscreen *row *col *numrow *numcol)
        (setq newtype nil)
        (setq screenprint nil)
        (setq screenpaint T) )  )
   (cond ((eq screenprint T)
                 (nsc 'a)
         (terpri 10) ) )
        (loop ((null text) )
          (setq block (car text))
          (setq text (cdr text))
          (cond ((eq block 'val)
              (setq block (pop text))
              (princ (get block 'value)) )
             ((eq block '!)
              (terpri) )
             ( T (princ block) ) ) )
   (cond ((eq outfile T)
        (wrs)
        (setq wrs nil) )
         ((eq outprint T)
           (setq wrs nil) )
         ((or (eq screenprint T) (eq screenpaint T))
        (terpri 2)
                (setq remrow (row))
        (set-cursor 21 3)
           (princ endtext-string)
        (setq *response (getfun))
        (set-cursor 21 3)
        (princ *bline*)
        (set-cursor remrow 2)
        (cond ((eq *response nil) T)
              ((neq *response nil)
             (funsupport *response)
             (advise holdadvise) ) )  ) ) )

(setq *bline*
 "                                                                   ")

; the following outputs a list of all attributes and their current
; status (value , and known/unknown)

(defun summary ()
   (nsc 'u)
   (terpri)
   (setq attributes kb-attr)
   (princ " ****  SUMMARY OF ATTRIBUTE STATUS  **** ")
   (terpri)
   (princ "Attribute : Type : Known/Unknown :  Value")
   (terpri)
        (loop ((null attributes) )
          (setq attrib (car attributes))
          (setq attributes (cdr attributes))
          (setq atype (get attrib 'type))
          (setq aknown (get attrib 'known))
          (setq avalue (get attrib 'value))
          (cond ((eq aknown T)
              (setq aknown '"Known"))
             ((eq aknown nil)
              (setq aknown '"Unknown"))  )
          (cond ((eq avalue nil)
              (setq avalue '"Not defined"))  )
          (princ (list attrib " : " atype " : " aknown " : " avalue))
          (terpri) )
   (terpri)
   (princ end-return)
   (cond ((eq " " (readassert)) T)  )  )

; used if called by the function key

(defun funsupport (*response)
   (cond

        ((eq *response 60)
             (explain))
        ((eq *response 61)
             (summary))
        ((eq *response 62)
             (support)) ) )

; provides user support functions -- you can add help here...

(defun support ()
   (nsc 's)
   (princ "****   SUPPORT UTILITY  ****" )
   (terpri)
   (princ "Select one of the following: " )
   (terpri)
   (princ "1. Summary of Attributes") (terpri)
   (princ "2. Explain Current Rule") (terpri)
   (princ "3. Return to program ") (terpri)
   (princ "4. Quit")(terpri 2)
   (princ "Enter selection: ")
   (setq choice (readnum))
   (cond ((eq choice 1) (summary)(support))
         ((eq choice 2) (explain)(support))
         ((eq choice 3) (nsc 'a) T)
         ((eq choice 4) (end-session) )  ) )


; a crude explanation facility follows
; it output the current if-then under consideration from either
; a task condition or a rule

(defun explain ()
   (nsc 'u)
   (princ "   ****  EXPLANATION FACILITY  ****  " )
   (terpri)
   (cond ((eq evkb nil)
        (princ "There is no rule under consideration at the moment")
        (terpri) )
         ((eq evkb T)
          (princ "The Following Rule is Currently Under Consideration: ")
          (terpri)
          (princ "IF  ")
        (setq print-rule-if (cadr rule))
        (loop ((null print-rule-if))
             (cond ((neq (car print-rule-if) nil)
                  (princ " ")
                  (princ (car print-rule-if)) ) )
                        (setq print-rule-if (cdr print-rule-if)) )
        (terpri)
          (princ "THEN   ")
        (setq print-rule-then (cddr rule))
        (loop ((null print-rule-then))
             (cond ((neq (car print-rule-then) nil)
                  (cond ((eq (car print-rule-then) 'action)
                       (terpri) ) )
                  (princ (car print-rule-then)) ) )
             (setq print-rule-then (cdr print-rule-then)) )
          (terpri)
        (terpri)
          (princ "  Based on the following query: ")
        (terpri)
          (princ question)
          (terpri)
          (princ "  Which will be used to ultimately determine: ")
          (terpri)
          (princ "     IF  ")
          (princ rattr)
          (princ " ")
          (princ roper)
          (princ " ")
          (princ rvalue)  ) )
   (terpri)
   (princ end-return)
   (cond ((eq " " (readassert)) T) )  )



; initialization functions follow, these are used to set up a knowledge
; base file

(setq kbfiles nil)

; the following gets a knowledge base file name to initialize it

(defun getkb ()
   (cond ((eq kbfiles nil)
        (terpri 2)
        (princ "Enter knowledge base filename: ")
        (clear-input)
        (setq getkbfile (read))
        (terpri) ) )
   (terpri 2)
   (princ "Loading ")
   (princ getkbfile)
   (terpri 2)
   (load-kb getkbfile)
   (princ "Knowledge base is initialized.")
   (clear-screen)  )

; the following actually loads the kb file

(defun load-kb (kbfilename)
   (setq kbfiles (append kbfiles kbfilename))
   (rds kbfilename)
   ((eq rds nil)
    (princ kbfilename)
    (princ " file is not available...")
    (terpri)
    (end-session))
   (loop ((not (listen)))
        (eval (read))
         (setq fptr (readptr))
        (read-line)
         ((not (listen)))
        (readptr fptr) )
   (rds)
        (setq rds nil) )


;  the following initialize the knowledge base

; sets up an attribute

(defun attribute (nlambda
        (aname atype *val* avalue *asource* asource *menu* amenu)
   (setq knowledge-base (append knowledge-base (list
 (list 'attribute aname atype *val* avalue *asource* asource *menu*
amenu))))
   (setq kb-attr (append kb-attr (list aname)))
   (put aname 'anattr T)
   (put aname 'type atype)
   (put aname 'value avalue)
   (cond ((eq *asource* 'query)
        (put aname 'source 'query)
        (put aname 'query asource))
         ((eq *asource* 'function)
        (put aname 'source 'function)
        (put aname 'function asource)) )
   (put aname 'menu amenu)
   (cond ((eq avalue nil) (put aname 'known nil))
         ((neq avalue nil) (put aname 'known T)) )  )   )


; sets up a task

(defun task (nlambda (taskname *if* ifclause *action* taskitems)
   (setq element nil)
   (setq tifpart nil)
   (setq tasknamelist (append tasknamelist (list taskname)) )
   (setq tasklist (append tasklist (list taskname))  )
   (cond ((eq *if* 'if)
        (setq task (cdr task))
        (setq tifpart (cons 'if ifclause)) )
         ((eq *if* 'action)
        (setq tifpart nil)
        (setq taskitems ifclause)) )
   (gen-action taskitems)
   (setq taction action-part)
   (setq telement (list tifpart taction))
   (setq element (list 'task telement))
   (setq kb-task (append kb-task (list element))) ) )

; sets up actions for tasks and rules

(defun gen-action (action)
   (setq action-part nil)
   (setq adv-part nil)
   (setq res-part nil)
   (loop ((null action))
          (cond ((eq (car action) 'advise)
             (set-advise) )
             ((eq (car action) 'mathattr)
             (set-mathattr) )
             ((eq (car action) 'set-attribute)
             (set-set-attribute)  )
             ((eq (car action) 'ask-attribute)
             (set-ask-attribute)  )
             ((eq (car action) 'reset-attribute)
             (set-reset-attribute)  )
             (T (princ "No function exists... ")
             (princ (car action))
             (terpri)
             (princ end-return)
             (setq nf-resp (readsymbol)) )   )  )  )

(defun set-advise ()
   (pop action)
   (setq adv-part (list 'advise (list 'quote (pop action))))
   (setq action-part (append action-part (list adv-part))) )


(defun set-mathattr ()
   (setq math-part nil)
   (setq math-part (append math-part (list (pop action))))
   (setq math-part (append math-part (list (pop action))))
   (setq math-part (append math-part (list (pop action))))
   (setq math-part (append math-part (list (pop action))))
   (setq action-part (append action-part (list math-part)))  )

(defun set-set-attribute ()
   (setq set-attr nil)
   (setq set-attr (append set-attr (list (pop action))))
   (setq set-attr (append set-attr (list (pop action))))
   (setq set-attr (append set-attr (list (pop action))))
   (setq action-part (append action-part (list set-attr)))  )

(defun set-ask-attribute ()
   (setq ask-attr nil)
   (pop action)
   (setq ask-attr (append ask-attr (list 'determine-attribute
                       (pop action))))
   (setq action-part (append action-part (list ask-attr)))  )


(defun set-reset-attribute ()
   (setq res-part nil)
   (setq res-part (append res-part (list (pop action))))
   (setq res-part (append res-part (list (pop action))))
   (setq action-part (append action-part (list res-part)))   )

; sets up a rule
; a rule list is set up
; a rule conclusion list is also set up to shorten search time


(defun rule (nlambda
   (rulename *if* ifclause *then* thenattr *is* thenvalue *action*
        actionitems)
   (setq connector nil)
   (cond ((eq *action* 'action)
        (gen-action actionitems)
        (setq a-part action-part) )
         ((neq *action* 'action)
        (setq a-part nil) ) )
   (setq new-rule-if ifclause)
   (setq rule-if nil)
        (loop ((null new-rule-if))
          (setq rule-if (append rule-if (list (pop new-rule-if))))
          (setq rule-if (append rule-if (list (pop new-rule-if))))
          (setq rule-if (append rule-if (list (pop new-rule-if))))
          (cond ((neq (car new-rule-if) nil)
              (setq connector (car new-rule-if))))
          (setq new-rule-if (cdr new-rule-if)) )
   (setq rule-if (cons connector rule-if))
   (setq rule-then (list thenattr 'is thenvalue a-part))
   (setq newrule (list rulename rule-if rule-then))
   (setq kb-rule (append kb-rule (list newrule)))
   (setq rule-con (list thenattr rulename))
   (setq kb-rule-con (append kb-rule-con (list rule-con)))   )   )


; the following code is the inference engine



; the following actually runs the tasks in sequential order

(defun runkb ()
    (setq taskposition (position (car tasklist) tasknamelist))
    (setq current-task (pop tasklist))
    (run-task (nth taskposition kb-task))
   ((null tasklist) (return))
    (runkb)  )

; gets the task for execution

(defun do-task (taskname)
   (setq taskposition (position taskname tasknamelist))
   (run-task (nth taskposition kb-task))  )

; following evaluates a single task by evaluating condition
; and/or executing actions

(defun run-task (taskaction)
   (setq evkb nil)
   (setq task (cdr taskaction))
   (setq task (car task))
   (cond ((eq (car task) nil)
        (setq taskact (cadr task))
        (do-thenactions taskact) ) )
        (cond ((neq (car task) nil)
           (setq evkb T)
           (setq jumpout nil)
           (setq taskif (car task))
           (setq taskif (cdr taskif))
                (loop  ((or (null taskif) (eq jumpout T)) )
                   (setq rattr (pop taskif))
                   (setq roper (pop taskif))
                   (setq rvalue (pop taskif))
                   (setq continue (eval-kb rattr roper rvalue))
; the following checks to verify no nested eval-kb s were run
                   (setq continue (eval-kb rattr roper rvalue))
                   (cond ((and (eq (car taskif) and) (eq continue nil))
                       (setq jumpout T) )
                      ((and (eq (car taskif) or) (eq continue nil))
                       (setq jumpout nil)
                       (setq taskif (cdr taskif)) )
                      ((and (eq (car taskif) and) (eq continue T))
                       (setq jumpout nil)
                       (setq taskif (cdr taskif)) )
                      ((or (neq (car taskif) and)
                            (neq (car taskif) 'or))
                       (setq jumpout T) ) ) )
        (cond ((eq continue T)
             (setq taskact (cadr task))
             (do-thenactions taskact) )) ) )  )

; following figures out what an attribute value is by asking the user
; it calls functions that follow

(defun determine-attribute (attr)
   (cond ((eq (get attr 'source) 'query)
        (ask attr))
         ((eq (get attr 'source) 'function)
        (eval-attr attr) ) )  )

; a function value can be assigned to an attribute
; for example, the system date could be assigned to the attribute
; by calling a routine to get the date
; the syntax is :
; (attribute <attrname> <type> value <val> function (<LISP function>))


(defun eval-attr (attr)
   (set-attribute attr (eval (get attr 'function))) )

; actually asks the question using ask-string, ask-number etc..

(defun ask (attr)
   (setq question (get attr 'query))
   (setq askmenu (get attr 'menu))
   (cond ((eq (get attr 'type) 'assertion)
        (ask-assertion attr question))
         ((eq (get attr 'type) 'string)
        (ask-string attr question askmenu))
         ((eq (get attr 'type) 'symbol)
        (ask-symbol attr question askmenu))
         ((eq (get attr 'type) 'number)
        (ask-number attr question askmenu))  ) )


(defun ask-assertion (attr question)
   (nsc 'q)
   (terpri)
   (princ question)
   (princ " (y or n):  ")
   (setq answer (readassert))
   (cond  ((eq answer *keyint)
        (support)
        (ask-assertion attr question) )
          ((or (eq answer '"Y") (eq answer '"y"))
        (put attr 'value 'true)
        (put attr 'known T))
          ((or (eq answer '"N") (eq answer '"n"))
        (put attr 'value 'false)
        (put attr 'known T))
          (T (ask-assertion attr question)) ) )

(defun ask-string (attr question smenu)
   (cond ((eq smenu nil)
        (nsc 'm)
        (terpri)
        (princ question)
        (princ " :  ")
        (setq answer (readstring))
        (cond ((eq answer *keyint)
             (support)
             (ask-string attr question smenu)) )
        (put attr 'value answer)
        (put attr 'known T))
         ((neq smenu nil)
        (ask-menu attr question smenu))  )  )


(defun ask-symbol (attr question smenu)
   (cond ((eq smenu nil)
        (nsc 'q)
        (terpri)
        (princ question)
        (princ " :  ")
        (setq answer (readsymbol))
        (cond ((eq answer *keyint)
             (support)
             (ask-symbol attr question smenu)) )
        (put attr 'value answer)
        (put attr 'known T))
         ((neq smenu nil)
        (ask-menu attr question smenu))  )  )

; is used to display a menu

(defun ask-menu (attr question menulist)
        (nsc 'm)
        (terpri)
        (setq prinmenu menulist)
        (princ "Menu Question Follows ")
        (terpri 2)
        (princ question)
        (terpri)
        (setq counter 1)
                (loop  ((null prinmenu) )
               (princ counter)
               (princ ".  ")
               (princ (pop prinmenu))
               (terpri)
               (setq counter (+ counter 1)) )
        (setq counter (sub1 counter))
        (terpri)
        (princ "    Enter the number of selection: ")
        (setq menuchoice (readnum))
        (cond ((eq menuchoice *keyint-sym) (support)
             (ask-menu attr question menulist))
              ((or (lt menuchoice 1)(gt menuchoice counter))
             (ask-menu attr question menulist)))
        (setq mcount 0)
        (setq prinmenu menulist)
                (loop  ((eq mcount menuchoice))
                    (setq mcount (incq mcount))
               (setq answer (pop prinmenu)) )
        (put attr 'value answer)
        (put attr 'known T) )

(defun ask-number (attr question nmenu)
   (cond ((eq nmenu nil)
        (nsc 'q)
        (terpri)
        (princ question)
        (princ " :  ")
        (setq answer (readnum))
        (cond ((eq answer *keyint-sym)(support)
               (ask-number attr question nmenu))
              ((not (nump answer))(terpri)
               (princ "Please enter a number value: ")
               (ask-number attr question nmenu)) )
        (put attr 'value answer)
        (put attr 'known T))
         ((neq nmenu nil)
        (ask-menu attr question nmenu) ) ) )


; heart of the inference mechanism
; evaluates conditions by testing if known, checking for rules
; or asking questions

(defun eval-kb (kattr koper kvalue)
   (reset-rules)
   (setq eattr kattr)
   (setq eoper koper)
   (setq evalue kvalue)
   (cond ((eq (member kattr kb-attr) nil)
          (princ "The following attribute is not defined:  ")
          (princ kattr) )
         ((neq (member kattr kb-attr) nil)
          (cond ((eq (get eattr known) T)
              (test-condition eattr eoper evalue) )
             ((eq (get eattr known) nil)
              (cond ((eq (find-rule eattr) nil)
                  (determine-attribute eattr) ) )
              (setq cond-not-fired T)
                      (loop  ((eq (attr-known eattr) T))
                 (setq cond-not-fired T)
                      (fire-rule eattr) )
              (cond ((eq (get eattr 'value) nil)
                    (determine-attribute eattr) )  )
              (eval-kb eattr eoper evalue)) ) ) ) )


; compares attributes to some value based on an operator

(defun test-condition (tattr oper svalue)
   (cond ((neq (get svalue 'value) nil)
          (setq svalue (get svalue 'value)) ) )
         (cond
             ((and (eq oper 'leq)
                (eq (get tattr 'type) 'number)
                (le (get tattr value) svalue)) T)
             ((and (eq oper 'less)
                (eq (get tattr 'type) 'number)
                (lt (get tattr value) svalue)) T)
             ((and (eq oper 'greater)
                (eq (get tattr 'type) 'number)
                (gt (get tattr value) svalue)) T)
             ((and (eq oper 'geq)
                (eq (get tattr 'type) 'number)
                (ge (get tattr value) svalue)) T)
             ((and (eq oper 'is)
                (eq (get tattr value) svalue)) T)
             ((and (eq oper 'isnot)
                (neq (get tattr value) svalue)) T)
             (nil)  ) )

; recursively checks/fires rules to evaluate an attribute
; this is called by eval-kb
; and uses rule and conclusion lists

(defun fire-rule (attr)
   (setq ifstate nil)
   (setq rule (get-rule (find-rule attr)))
   (setq ifpart (cadr rule))
   (setq typeif (car ifpart))
   (setq ifpart (cdr ifpart))
   (setq thenpart (caddr rule))
   (cond ((eq typeif 'and)
          (setq ifstate (and-rule ifpart)))
         ((eq typeif 'or)
          (setq ifstate (or-rule ifpart)))
         ((eq typeif nil)
          (setq ifstate (and-rule ifpart)) ) )
   (cond ((eq ifstate T)
          (reset-rules)
          (set-attribute (car thenpart) (caddr thenpart))
          (cond ((and (neq (cadddr thenpart) nil)
                        (eq cond-not-fired T) )

              (setq cond-not-fired nil)
              (setq thenaction (cadddr thenpart))
              (do-thenactions thenaction)
              (setq thenaction nil) ) )
              T)
         ((eq ifstate nil)
          (setq nomorerule (get (car (last foundrule)) 'tried))
          (cond ((eq nomorerule T)
              (set-nilcond (car thenpart) (caddr thenpart)) )
             ((eq nomorerule nil)
              (fire-rule attr) ) )
        nil) )  )


; does the actions called by tasks or rules

(defun do-thenactions (thenaction)
   (loop  ((null thenaction) )
          (eval (car thenaction))
          (setq thenaction (cdr thenaction)) ) )


; and-rule and or-rule are called by fire-rule to test conditiion
; types


(defun and-rule (if-part)
   (setq ifpart if-part)
   (setq ifstate T)
   (cond ((null ifpart) (return ifstate)) )
   (setq ifattr (car ifpart))
   (cond ((eq (attr-known ifattr) T)
          (setq ifpart (cdr ifpart))
          (setq oper (car ifpart))
          (setq ifpart (cdr ifpart))
          (setq ifvalue (car ifpart))
          (setq ifpart (cdr ifpart))
          (setq ifstate (test-condition ifattr oper ifvalue))
          (cond ((eq ifstate nil) nil)
             ((eq ifstate T) (and-rule ifpart)) ) )
         ((eq (attr-known ifattr) nil)
          (cond ((eq (find-rule ifattr) nil)
              (determine-attribute ifattr)
              (and-rule ifpart)  )
             ((neq (find-rule ifattr) nil)
             (setq cond-not-fired T)
              (fire-rule ifattr)) )  ) ) )

(defun or-rule (if-part)
   (setq ifpart if-part)
   (setq ifstate nil)
   (cond ((null ifpart) (return ifstate)) )
   (setq ifattr (car ifpart))
   (cond ((eq (attr-known ifattr) T)
          (setq ifpart (cdr ifpart))
          (setq oper (car ifpart))
          (setq ifpart (cdr ifpart))
          (setq ifvalue (car ifpart))
          (setq ifpart (cdr ifpart))
          (setq ifstate (test-condition ifattr oper ifvalue))
          (cond ((eq ifstate T) T)
             ((eq ifstate nil) (or-rule ifpart)) ) )
         ((eq (attr-known ifattr) nil)
          (cond ((eq (find-rule ifattr) nil)
              (determine-attribute ifattr)
              (or-rule ifpart)   )
             ((neq (find-rule ifattr) nil)
              (setq cond-not-fired T)
              (fire-rule ifattr)) ) )) )

; tests to see if an attribute is already known

(defun attr-known (kattr)
   (get kattr 'known)  )

; sets an attribute to a value

(defun set-attribute (sattr svalue)
   (cond ((neq (get svalue 'value) nil)
          (setq svalue (get svalue 'value)) ) )
   (put sattr 'value svalue)
   (put sattr 'known T) )

; sets an attribute to an unknown condition if it cannot be determined
; by anything-basically a fail-safe

(defun set-nilcond (nattr nvalue)
   (put nattr 'value nil)
   (put nattr 'known T)  )

; used to manually reset an attribute to unknown
; this can be called by the actions

(defun reset-attribute (rattr)
   (put rattr 'value nil)
   (put rattr 'known nil)  )

; add, sub, multiply, and divide functions for attributes

(defun mathattr (mattr moper mtarg)
   (cond ((eq (get mattr 'known) nil)
          (eval-kb mattr) ) )
   (cond ((eq (nump mtarg) nil)
        (cond ((eq (get mtarg 'known) nil)
             (eval-kb mtarg nil nil) ) )
        (setq mval (get mtarg 'value)) )
         ((eq (nump mtarg) T)
          (setq mval mtarg) ) )
   (cond ((eq moper 'plus)
          (set-attribute mattr
          (+ (get mattr 'value) mval))  )
         ((eq moper 'minus)
          (set-attribute mattr
          (- (get mattr 'value) mval))  )
         ((eq moper 'times)
          (set-attribute mattr
          (* (get mattr 'value) mval))  )
         ((eq moper 'div)
          (set-attribute mattr (/ (get mattr 'value) mval)) ) ) )

; looks for a rule in the rule list

(defun find-rule (attr)
   (setq foundrule nil)
   (setq rulelist kb-rule-con)
        (loop  ((null rulelist) )
          (cond ((eq (caar rulelist) attr)
              (setq foundrule (append foundrule (list
                       (car (cdr (car rulelist))))))
              (setq rulelist (cdr rulelist)) )
             ((neq (caar rulelist) attr)
              (setq rulelist (cdr rulelist))) ) )
   (setq rulelist foundrule)  )


; returns a rule in the rule list

(defun get-rule (rname)
   (setq rulename (car rname))
   (setq rname (cdr rname))
   (cond ((eq (get rulename 'tried) T)
          (get-rule rname) ) )
   (put rulename 'tried T)
   (setq rulelist kb-rule)
        (loop  ((eq (car rule) rulename)(return rule))
           (setq rule (car rulelist))
           (setq rulelist (cdr rulelist)) ) )

; is used to reset the rules for subsequent evaluations

(defun reset-rules ()
   (setq allrules kb-rule-con)
        (loop  ((null allrules) )
          (put (cadr (car allrules)) 'tried nil)
          (setq allrules (cdr allrules)) ) )


; following saves the aubrey file for later execution

(save aubrey.sys)




(rds)


; *******************************************************************
; *******************************************************************

; the following code should be removed for development
; purposes


; to execute the following enter "aubrey" at the prompt
; when the driver is executed


; the following is a demonstration file of how the knowledge base
; syntax is used

; the following is a task with no condition and an advise clause
; the ask-attribute shows how an attribute can be forced into
; instantiation

(task intro
action (
advise (
val your_name ", this will demonstrate how the system works by advising you "
"on your breakfast habits..." ! !
"Note: the advice in this demonstration is not to be taken seriously.")
ask-attribute age) )

; typical queries follow, note that the value - nil could
; be replaced with a real value

(attribute eat_breakfast assertion value nil
	query "Do you like to eat breakfast ")

(attribute age number value nil query "How old are you ")

; the following shows how a menu can be created

(attribute breakfast_items string value nil
   query "Select one of the following breakfast items as your favorite: "
	menu ("fruit and cereal" "pancakes" "eggs") )

(attribute your_name string value nil
	query "What is your name ")

(attribute breakfast_recom string value nil)

; rules have up to 5 parts
;    1.  (rule
;    2.        <rulename>  - - must be unique for each rule
;    3.   if (<condition>)  - - must be "and" or "or", cannot be mixed
;    4.   then <condition>
;    5.   action <action statements>  - - this is optional
;   task and rule actions can contain the same set of action items

(rule no_eat_breakfast1
	if (eat_breakfast isnot true
	and age less 16)
	then breakfast_recom is "poor"
	action (
	advise (val your_name ", at your age, you should eat breakfast...")
	set-attribute breakfast_items "to not eat breakfast"))

(rule no_eat_breakfast2
	if (eat_breakfast isnot true
	and age geq 16)
	then breakfast_recom is "poor"
	action (
	advise (val your_name ", you really should eat breakfast to"
	" keep your " !
	" energy up for a hard days work...")
	set-attribute breakfast_items "to not eat breakfast"))


(rule set_breakfast1
	if (eat_breakfast is true
	and breakfast_items is "fruit and cereal")
	then breakfast_recom is "good")

(rule set_breakfast2
	if (eat_breakfast is true
	and age less 16
	and breakfast_items is "pancakes")
	then breakfast_recom is "fair")

(rule set_breakfast3
	if (eat_breakfast is true
	and age less 16
	and breakfast_items is "eggs")
	then breakfast_recom is "fair"
	action (
	advise (
	"You should watch eggs, they are high in cholesterol.")))


(rule set_breakfast4
	if (eat_breakfast is true
	and age geq 16
	and breakfast_items is "pancakes")
	then breakfast_recom is "fair"
	action (
	advise ("Pancakes should be eaten with very little syrup.")))

(rule set_breakfast5
	if (eat_breakfast is true
	and age geq 16
	and breakfast_items is "eggs")
	then breakfast_recom is "poor"
	action (
	advise (
	"You should watch eggs, they are high in cholesterol.")))


; the advise values are instantiated by firing rules in the
; following task

(task breakfast_attitude
action (
advise (
"Your breakfast habits are " val breakfast_recom
"  based on your age " val age !
"and you like " val breakfast_items)) )

; the following shows a condition to fire the task

(task age_recom
 if (age geq 16)
action (
advise (
"Because of your age (" val age ") you should watch what you eat.")))
