AWK scripts and associated data files to accompany the article:
AWKWARD: Toward Database Reasoning
by Yuval Lirov and Swaminathan Ravikumar
Appearing in the October 1989 Issue of AI EXPERT
All Rights Reserved

\05	/^IF.*/ {
\06		gsub(/[ $bsl$t]*IF[ $bsl$t]*/, ""); # remove keyword "IF"
\07		gsub(/[ $bsl$t]*IS[ $bsl$t]*/, ":"); # remove keyword "IS"
\08		printf("%s:rule%d$bsl$n", $ DD$0, counter) >> "condtable";
\09	}
10
11	/^THEN.*/ {
12		gsub(/[ $bsl$t]*THEN[ $bsl$t]*/, ""); # remove keyword "THEN"
13		gsub(/[ $bsl$t],*IS[ $bsl$t]*/, ":"); # remove keyword "IS"
14		printf("%s:rule%d$bsl$n", $ DD$0, counter++) >> "actiontable";
15	}

Figure 1.  Translation Script

\01	IF IC1-10 IS -5v
\02	THEN measure with voltmeter IS IC2-25
\03	IF IC2-25 IS +5v
\04	THEN replace`````IS IC6

Figure 2.  Sample Rule Base in Rule Format


\01	IC1-10:-5v:rule0
\02	IC2-25:+5v:rule1

Figure 3a.  Sample Rule Base Condition Table

\01	measure with voltmeter:IC2-25:rule0
\02	replace:IC6:rule1


Figure 3b.  Sample Rule Base Action Table

\01	BEGIN {
\02		ARGV[1] $fat =$ "-";
\03		printf("Enter initial condition : ");
\04		getline;
\05		subject $=$ $DD$1;
\06		value $=$ $DD$2;
\07		FS $=$ ":";
\08
\09		for (;;) {
10			if ((ruleid $=$ find_ruleid(subject, value)) !$=$ "") {
11				if ((action $=$ find_action(ruleid)) !$=$ "") {
12					split (action, ary) ;
13					printf("%s %s : ", ary[1], ary[2]);
14					getline value;
15					subject $=$ ary[2];
16					close("condtable");
17					close("actiontable");
18				}
19				else
20					break;
21			}
22			else
23				break;
24		}
25	}
26
27	function find_ruleid(subject, value)
28	{
29		while ((getline <"condtable") > 0) {
30			if ($DD$1 $=$$=$ subject && $DD$2 $=$$=$ value)
31				return $DD$3; ````````# return rule id
32		}
33		return "";
34	}
35
36	function find_action(ruleid)
37	{
38		while ((getline <"actiontable") > 0)  {
39			if ($DD$3 $=$$=$ ruleid)
40				return $DD$1 ":" $DD$2;`````# return action and subject
41		}
42		return "";
43	}

Figure 4.  Inference Engine By Queries


\01	BT 12-18-88 16:05:38
\02	TS DAISY1
\03	BC TN754 V12
\04	SN 8DC379700
\05	BR P
\06	LC D02
\07	OC SHIPPED FROM POS. 101, 16:05:38 SUN.DEC.18
\08	TO 1
\09	ET 12-18-88 16:05:38
\10	BT 12-18-88 17:12:27
\11	TS FR1
\12	BC TN742 V10
\13	SN 6D4316300
\14	BR P
\15	LC B04
\16	OC SHIPPED FROM POS. 216, 17:12:27 SUN. DEC.18
\17	TO 1
\18	ET 12-18-88 17:12:27
\19	BT 12-19-88 13:40:28
\20	TS ABNER1
\21	BC TN753 V8
\22	SN 8DC379300
\23	BR F
\24	LC A10
\25	LP 1
\26	PN 4
\27	ST 33
\28	FS 25255
\29	FT 3:34:00
\30	TI RAS
\31	TO 1
\32	ET 12-19-88 13:40:28

Figure 6a. Data File


\01	BEGIN {
\02		RS = "";
\03		FS = "$bsl$n";
\04	}
\05
\06	$DD$1 $wig$ /^BC/ {
\07		filename $=$ $DD$2;	# field two is pack code
\08		for (i = 1; i <= NF; i++)
\09		`````printf("%s$bsl$n", $DD$i) >> filename	# append data to filename
10		close(filename);	# cannot have too many open files
11	}

Figure 6b. Classifying the Circuit Packs

\01	BT 01-03-89 09:47:41
\02	TS DAISY2
\03	BC TN742 V17
\04	SN 8DC379800
\05	BR P
\06	LC C11
\07	OC SHIPPED FROM POS. 201, 9:47:41 TUE. JAN. 3
\08	TO 1
\09	ET 01-03-89 09:47:41
\10
\11	BT 01-03-89 13:08:35
\12	TS FR1
\13	BC TN742 V16
\14	SN 7D7320600
\15	BR P
\16	LC C12
\17	OC SHIPPED FROM POS. 216, 13:08:34 TUE. JAN. 3
\18	TO 1
\19	ET 01-03-89 13:08:35
\20	
\21	BT 01-03-89 10:04:31
\22	TS FR1
\23	BC TN742 V10
\24	SN 5D9303300
\25	BR P
\26	LC C19
\27	OC SHIPPED FROM POS. 109, 10:04:31 TUE. JAN. 3
\28	TO 1
\29	ET 01-03-89 10:04:31
\30	

Figure 6c. Classified Data File

\01	BEGIN {
\02		FS $=$ " ";
\03		OFS $=$ "$bsl$t"
\04		teststep $=$ "default";
\05	}
\06
\07	$DD$1 $wig$ /^BT/ {
\08		split($DD$2, time, "-")
\09		yy $=$ time[3]
10		(length(time[1]) $=$$=$ 2) ? mm $=$ time[1] : mm $=$ "0" time[1]
11		(length(time[2]) $=$$=$ 2) ? dd $=$ time[2] : dd $=$ "0" time[2]
12		mtime $=$ yy "-" mm "-" dd
13	}
14	$DD$1 $wig$ /^ST/ {
15		teststep $=$ $DD$2
16	}
17	$DD$1 $wig$ /^AC/ {
18		action $=$ $DD$2
19	}
23	$DD$1 $wig$ /^PI/ {
21		part $=$ $DD$2
22	}
23	$DD$1 $wig$ /^SN/ {
24		serial$=$ $DD$2
25	}
26	$DD$1 $wig$ /ET/ {
27		printf("%s$bsl$t%s$bsl$t%s$bsl$t%s$bsl$t%s$bsl$n",
28			serial, mtime, teststep, action, part) \(bv "sort";
29		teststep $=$ "default";
30		mtime $=$ "";
31		action $=$ "";
32		part $=$ "";
33		serial $=$ "";
34	}

Figure 7a.  Creating the History of the Replacements on a Circuit Pack

\01	4DB198010	88-12-02	200		
\02	4DB198010	88-12-06	default	REPLACED	IC17.4
\03	4DC137807	88-10-02	200		
\04	4DC137807	88-10-04	default	REPLACED	C22.7
\05	5D3334309	88-12-10	47		
\06	5D3334309	88-12-13	default	REPLACED	IC16.7
\07	5D3388705	88-10-15	51		
\08	5D3388705	88-10-27	default	REPLACED	C32


Figure 7b.

\01	# $DD$1 - serial; $DD$2 $=$ time; $DD$3 $=$ teststep, $DD$4 $=$ action; $DD$5 $=$ part
\02
\03	BEGIN {
\04		teststep$=$"";
\05		serial$=$"";
\06	}
\07
\08	{
\09		if ((NF $=$$=$ 5) && ($DD$1 $=$$=$ serial) && ($DD$4 !$=$ "NO") &&
10				`````(teststep !$=$ "default"))
11			printf("%s$bsl$t%s$bsl$t%s$bsl$t%s$bsl$n", teststep, $DD$4, $DD$5, $DD$1) \(bv "sort"
12		else
13			if ((NF $=$$=$ 3) && ($DD$3 !$=$ "default")) {
14				`serial $=$ $DD$1;
15				`teststep $=$ $DD$3;
16				}
17	}

Figure 8a.  Building Failure-Replacement Relation from History Files

\01	200	REPLACED	C22.7	4DC148913
\02	200	REPLACED	IC17.4	4DC137811
\03	200	REPLACED	IC17.3	4DC148510
\04	200	REPLACED	IC17.3	5D6362208
\05	47	REPLACED	IC1	7D6311409
\06	47	REPLACED	IC1	8D9069509
\07	47	REPLACED	IC10	7D5383800
\08	47	REPLACED	IC11	6DC374112
\09	47	REPLACED	IC11	8DC375604
\10	47	REPLACED	IC11	8DC379805
\11	47	REPLACED	IC11	9D1375501
\12	47	REPLACED	IC12	7DC028512
\13	47	REPLACED	IC12	8D9313403
\14	47	REPLACED	IC12	8D9313403
\15	47	REPLACED	IC12	8DC379805
\16	47	REPLACED	IC12	9D1391710

Figure 8b.

\01	# $DD$1 $=$ teststep; $DD$2 $=$ action; $DD$3 $=$ part; $DD$4 $=$ serial
\02
\03	BEGIN {
\04		teststep$=$"";
\05		replacement$=$"";
\06		counter$=$0;
\07	}
\08
\09	NF $=$$=$ 4 {
10		if (teststep $=$$=$ $DD$1 && replacement $=$$=$ $DD$3)
11			counter++;
12		else {
13			printf("%s$bsl$t%2d$bsl$d%s$bsl$n", teststep, counter,
14				replacement) \(bv "sort -r"
15			teststep $=$ $DD$1;
16			replacement $=$ $DD$3;
17			counter $=$ 1;
18		}
19	}

Figure 9.  Constructing Advice Table from Failure-Replacement Relation


1    BEGIN {
2	# read advicetable into an associative array whose index is test step
3	while (getline < "advicetable" > 0)
4	  rule[$dollar$1] = rule[$dollar$1] $dollar$3 ":";
5	
6	for (;;) {
7	  printf("Enter serial number : ");
8        if (getline > 0) {
9	    if ($dollar$1 != pvsno)                             # if entered serial no != previous serial no
10	      ctsno = $dollar$1;                                 # initialize current serial no
11	    printf("Enter test step     : ");
12          if (getline > 0) {
13	      if ($dollar$1 in rule) {
14	        if ($dollar$1 != pvtsp) # if entered test step != previous test step
15	          cttsp = $dollar$1;	 # initialize current test step
16		if (cttsp == pvtsp && ctsno == pvsno) {
17		  # both serial no and test step are same as previous one
18		  # and previous suggestion did'nt fix the problem
19		  spcnt = split(rule[cttsp], ary, ":") - 1;
20		  if (idxcnt < spcnt)
21		    # give the next most probable suggestion
22		    printf("$bsl$n$bsl$t$bsl$t****Replace %s ****$bsl$n", ary[++idxcnt]);
23		  else {
24		    printf("$bsl$n$bsl$t$bsl$t**** Out of suggestions ****$bsl$n");
25		    pvsno = "";
26		    pvtsp = "";
27		  }
28		}	
29		else {
30		  # either serial no is different from previous one
31		  # or same serial no but different test step
32		  # or both serial no and test step are different
33		  idxcnt = 1;
34		  pvsno = ctsno;
35		  pvtsp = cttsp;
36		  split(rule[cttsp], ary, ":");
37		  printf("$bsl$n$bsl$t$bsl$t**** Replace %s****$bsl$n", ary[idxcnt]);
38		}
39	      }
40	      else {
41	        printf("$bsl$n$bsl$t$bsl$t**** Missing Knowledge ****$bsl$n");
42	        pvsno = "";
43	        pvtsp = "";
44	      }
45          }
46        }
47      }
49    }

Figure`11. Inference Script Using the Advice Tables
