"This file installs Class Random which implements a simple random number
 generator for Smalltalk/V.  To install this application evaluate the
 following expression with `do it' (note that since there is no '\' character
 in the path name, the file must be in the current directory):

    (File pathName: 'random.st') fileIn; close

 The class method `new' answers a new randomly initialized instance; the
 instance method `next' answers a pseudo-random number sampled uniformly from
 the interval [0.0, 1.0).  For example, evaluate
 
    (Foo := Random new) next

 with `show it'.

 There are also methods for managing the seed if you need to do so.  Uses
 floating-point arithmetic, so you need a math coprocessor."!

Object subclass: #Random
  instanceVariableNames: 
    'seed '
  classVariableNames: ''
  poolDictionaries: '' !

!Random class methods !

new
    "Return a new instance with its seed randomized
     by a value derived from the system clock."
    | tmp1 tmp2 |
    tmp1 := super new.
    tmp2 := Time millisecondClockValue // 10.
    tmp1 seed: (tmp2 * tmp2 \\ 65536).
    ^tmp1!

new: aSeed
    "Return a new instance with its seed set to aSeed which
     must an integer in the range 1 .. 65535."
    | tmp |
    tmp := super new.
    tmp seed: aSeed.
    ^tmp! !


!Random methods !

next
    "This method is based on the one give on p. 130
     of Smalltalk-80 by Goldberg and Rabson"
    seed := 13849 + (27181 * seed) bitAnd: 16rFFFF.
    ^(seed / 65536.0)!

seed
    "Answer the seed.  This method allows the seed to stored at
     certain point in a random sequence so it be restarted from
     that point."
    ^seed!

seed: aSeed
    "Set the instance variable seed to aSeed which
     must an integer in the range 1 .. 65535."
    seed := aSeed! !
