% a DCG grammar that recognizes a subset of the syntax of Turbo Pascal
% procedures
actual_parameters --> term, [ ',' ], actual_parameters.
actual_parameters --> term.
adding_operator --> [+].
adding_operator --> [-].
adding_operator --> [or].
adding_operator --> [xor].
assignment_statement --> variable, [:=], expression.
block --> variable_declaration, statement_part.
conditional_statement --> [if], statement, [then], statement.
conditional_statement --> [if], statement, [then], statement, [else], statement.
constant --> [Integer], {isa_integer(Integer)}.
constant --> string.
expression --> simple_expression, expression_list.
expression --> simple_expression.
expression_list --> relational_operator, simple_expression.
id --> [Anything], {isa_pascal_id(Anything)}.
id_list --> id, [ ',' ], id_list.
id_list --> id.
procedure_declaration --> procedure_heading, block, [;].
procedure_heading --> [procedure], id, [;].
procedure_statement --> id, [ '(' ], actual_parameters, [ ')' ].
relational_operator --> [<=].
relational_operator --> [<>].
relational_operator --> [<].
relational_operator --> [=>].
relational_operator --> [>].
relational_operator --> [in].
simple_expression --> term, adding_operator, simple_expression.
simple_expression --> term.
simple_statement --> assignment_statement.
simple_statement --> procedure_statement.
statement --> simple_statement.
statement --> structured_statement.
statement_list --> [;], statement, statement_list.
statement_list --> [].
statement_part --> [begin], statement, statement_list, [end].
string --> [String], {isa_string(String)}.
structured_statement --> statement_part.
structured_statement --> conditional_statement.
term --> [Number], {isa_number(Number)}.
term --> variable.
term --> constant.
type --> [boolean].
type --> [integer].
type --> [string, '[' ], constant, [ ']' ].
variable --> id.
variable_declaration --> [var], variable_list.
variable_declaration --> [].
variable_list --> id_list, [:], type, [;], variable_list.
variable_list --> id_list, [:], type, [;].
while_statement --> [while], expression, [do], statement.

/* these are auxiliary definitions to allow playing with the grammar.
See the footnote in the article about how they work (or fail to): 
these are alright for Arity Prolog, but may be wrong for your Prolog */
isa_pascal_id(_).
isa_integer(X) :- integer(X).
isa_number(X) :- number(X).
isa_string(X) :- atom(X).

