VITA LISTING 1

nowarnings
domains
solution_list    =    symbol*
file             =    diskfile

predicates

on_board(integer,integer,integer,integer,integer,integer).
col_sym(symbol,integer).
knight_move(integer,integer,integer,integer,
     integer,integer,integer,integer).
knight_tour(integer,integer,solution_list,solution_list,
     integer,integer,integer,integer,integer,symbol).
append_atom(symbol,solution_list,solution_list).
equal(solution_list,solution_list).
member(symbol,solution_list).
length(solution_list,integer).
append(solution_list,solution_list,solution_list).
reverse(solution_list,solution_list).
write_list(solution_list).
write_time_date.
start(symbol,symbol,symbol,integer,integer,integer,symbol).
start2(symbol,integer,symbol,symbol,integer,integer,integer,symbol).
start8x8(symbol).

clauses

col_sym(a,1).
col_sym(b,2).
col_sym(c,3).
col_sym(d,4).
col_sym(e,5).
col_sym(f,6).
col_sym(g,7).
col_sym(h,8).

write_time_date :- date(Year,Month,Day),time(Hr,Min,Sec,Hun),
   write("Date: ",Month,"/",Day,"/",Year,"     Time:",
   Hr,":",Min,":",Sec,".",Hun).

on_board(X,Y,MinCol,MaxCol,MinRow,MaxRow) :-
      X >= MinCol, X <= MaxCol, Y >= MinRow, Y <= MaxRow.

knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X+1, V=Y+2,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X+1, V=Y-2,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X-1, V=Y+2,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X-1, V=Y-2,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X+2, V=Y+1,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X+2, V=Y-1,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X-2, V=Y+1,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).
knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow) :-
                U=X-2, V=Y-1,
                on_board(U,V,MinCol,MaxCol,MinRow,MaxRow).

equal(X,X).

append_atom(X,Y,[X|Y]).

member(X,[X|_]).
member(X,[_|Z]) :- member(X,Z).

length([],0).
length([_|Y],I) :- length(Y,J), I=J+1.

append([],X,X).
append([U|X],Y,[U|Z]) :- append(X,Y,Z).

reverse([],[]).
reverse([U|X],Y) :- reverse(X,Z),
                    append(Z,[U],Y).

write_list([]) :- nl,nl.

write_list([X|Y]) :-
                     write(X,"  "),
                     write_list(Y).

start(Z,MinC,MaxC,MinRow,MaxRow,SolutionSize,Device) :-
       frontstr(1,Z,X1,Y1),frontstr(1,Y1,X2,Y2),
       str_int(X2,XI),
       not(start2(X1,XI,MinC,MaxC,MinRow,MaxRow,SolutionSize,Device)),
       write("Time Out "),	
       write_time_date,nl,nl.

start2(X,Y,MinC,MaxC,MinRow,MaxRow,SolutionSize,p) :-
        writedevice(printer),
        write("Knight's Tour Problem ",
        " from Starting Square ",
        X,Y),nl,
        write(MinC," to ",MaxC,"  by  ",MinRow," to ",MaxRow,
        " Board with Solution Size of ",
        SolutionSize),nl,nl,
        str_int(V,Y),
        concat(X,V,Z),
        append_atom(Z,[],StartSolution),
        write("Time In "),nl,	
        write_time_date,nl,nl,
	col_sym(MinC,MinCol),col_sym(MaxC,MaxCol),
        col_sym(X,U),
        knight_tour(U,Y,StartSolution,Answer,
           MinCol,MaxCol,MinRow,MaxRow,SolutionSize,f).

start2(X,Y,MinC,MaxC,MinRow,MaxRow,SolutionSize,s) :-
        writedevice(screen),
        write("Knight's Tour Problem ",
        " from Starting Square ",
        X,Y),nl,
        write(MinC," to ",MaxC,"  by  ",MinRow," to ",MaxRow,
        " Board with Solution Size of ",
        SolutionSize),nl,nl,
        str_int(V,Y),
        concat(X,V,Z),
        append_atom(Z,[],StartSolution),
        write("Time In "),	
        write_time_date,nl,nl,
	col_sym(MinC,MinCol),col_sym(MaxC,MaxCol),
        col_sym(X,U),
        knight_tour(U,Y,StartSolution,Answer,
           MinCol,MaxCol,MinRow,MaxRow,SolutionSize,f).

start2(X,Y,MinC,MaxC,MinRow,MaxRow,SolutionSize,d) :-
        write("Enter Output File Name:"),nl,
        readln(FileName),
        openwrite(diskfile,FileName),
        writedevice(diskfile),
        write("Knight's Tour Problem ",
        " from Starting Square ",
        X,Y),nl,
        write(MinC," to ",MaxC,"  by  ",MinRow," to ",MaxRow,
        " Board with Solution Size of ",
        SolutionSize),nl,nl,
        str_int(V,Y),
        concat(X,V,Z),
        append_atom(Z,[],StartSolution),
        write("Time In "),	
        write_time_date,nl,nl,
	col_sym(MinC,MinCol),col_sym(MaxC,MaxCol),
        col_sym(X,U),
        knight_tour(U,Y,StartSolution,Answer,
           MinCol,MaxCol,MinRow,MaxRow,SolutionSize,f).

knight_tour(X,Y,Solution,NewSolution,MinCol,MaxCol,MinRow,MaxRow,
  SolutionSize,SearchType) :-
        knight_move(X,Y,U,V,MinCol,MaxCol,MinRow,MaxRow),
        col_sym(U2,U),
        str_int(V2,V),
        concat(U2,V2,S),
        not (member(S,Solution)),
        append_atom(S,Solution,NextSolution),
        knight_tour(U,V,NextSolution,NewSolution,
           MinCol,MaxCol,MinRow,MaxRow,SolutionSize,SearchType).

knight_tour(_,_,Solution,NewSolution,MinCol,MaxCol,MinRow,MaxRow,

part3

  SolutionSize,SearchType) :-
        length(Solution,N),
        N = SolutionSize,
        write("Solution Found"),nl,
        write_time_date,nl,
        reverse(Solution,RevSolution),
        write_list(RevSolution),nl,
        equal(Solution,NewSolution),
        SearchType = p.

start8x8(S1) :-
               write("Enter Output File Name:"),nl,
               readln(FileName),
               openwrite(diskfile,FileName),
               writedevice(diskfile),
               write("Knight's Tour Problem on 8x8 Board ",
                   "by Partitioning"),nl,
               write("Time In "),	
               write_time_date,nl,nl,
               frontstr(1,S1,C1,Rest1),frontstr(1,Rest1,R1,_),
               str_int(R1,Y1),col_sym(C1,X1),
               append_atom(S1,[],StartList),
               nl,nl,write("Starting Board 1 from ",S1),nl,nl,
      knight_tour(X1,Y1,StartList,Answer,1,4,1,5,20,p),
               equal(Answer,[S2|_]),
               frontstr(1,S2,C2,Rest2),frontstr(1,Rest2,R2,_),
               str_int(R2,V2),col_sym(C2,U2),
      knight_move(U2,V2,X2,Y2,5,8,1,5),!,
               col_sym(XC2,X2),str_int(YC2,Y2),
               concat(XC2,YC2,Z2),
               append_atom(Z2,[],Start2),
               nl,nl,write("Starting Board 2 from ",Z2),nl,nl,
      knight_tour(X2,Y2,Start2,Answer2,5,8,1,5,20,p),
               equal(Answer2,[S3|_]),
               frontstr(1,S3,C3,Rest3),frontstr(1,Rest3,R3,_),
               str_int(R3,V3),col_sym(C3,U3),
      knight_move(U3,V3,X3,Y3,1,8,6,8),!,
               col_sym(XC3,X3),str_int(YC3,Y3),
               concat(XC3,YC3,Z3),
               append_atom(Z3,[],Start3),
               nl,nl,write("Starting Board 3 from ",Z3),nl,nl,
      knight_tour(X3,Y3,Start3,Answer3,1,8,6,8,24,p),!.
