# mini-attack
 
A demo to help students get familiar with return-oriented programming attacks

## Changelog

*Fall 2022, created by Matt Ngaw (mngaw) and Nicholas Mesa-Cucalon (nmesacuc)*

*Spring 2023, updated by Matt Ngaw (mngaw) b/c the documentation was terrible lol*

## Files

The activity has two sides to it: `student` and `ta`.

```
.
├── README.md
├── student/
│   ├── hex2raw
│   ├── tap2.png
│   └── target
└── ta/
    ├── main.c
    ├── objdump.asm
    └── sol.txt
```

### Students

`hex2raw` is the utility program to generate byte sequences from a text file. 
See documentation in lab writeup.

`tap2.png` an image showing the C implementation of the tap2 function that the 
attack is to be executed on. In Attack Lab, the students get to see the C code
for the function they are trying to call, but the function is not called in the
main routine of `target` (hence why they are using an ROP attack).

`target` is the Linux binary with a return-oriented programming vulnerability.

### TAs

The files here are not meant to be seen by students. They are only meant to assist
the TA with leading the activity.

`sol.txt` is the solution in text form. It must be run through `hex2raw` to 
produce a binary that can be redirected to `target`.

`objdump.asm` is the disassembly of `target`. Students should figure out how to 
get their own copy of the objdump (e.g. `disassemble` in `gdb` or Linux's `objdump`.

`main.c` is the source code for this small attack.


## How to use

The job of the TA is to help guide the students into creating a solution that 
matches `sol.txt`. Some guiding steps for a TA leading this activity:

### Before

1. Review the Attack Lab handout (part 2 specifically) to 
understand what students are expected to know (`hex2raw`, Linux I/O redirection, 
`objdump`, gadgets).

2. Try to solve the activity yourself, or at least understand how the solution 
works. Be ready to draw the **stack diagram** and explain how the attack works.

### During

3. Describe the main objective of this activity (running tap2 with `target` even 
though `tap2` is never called in the main function of `target`. 

4. Conceptually describe how a return-oriented programming attack works with a 
stack diagram.

4. Have them run `target` to see what the program expects from them. They can't
see what the main function does, so use `gdb` or `objdump` to find out what `target`
does.

5. Explain the gadget farm, and show in the disassembley where these gadgets are in
memory.

6. Explain `hex2raw`, and why we need to use it instead of just passing `target` our 
sol.txt

7. Guide them towards finding the solution!