% Setup Display
colordef none, clf reset, whitebg(gcf,[0 0 0])
% set(gcf,'BackingStore','off')
h1 = figure(1);
% set(h1,'DoubleBuffer','on')

rate_slider = uicontrol('Style','Slider','Tag','rate', ...
  'Position', [75 30 150 16], 'Value', LearnRate/1.5, 'SliderStep',[.005 0.1], ...
  'CallBack','LearnRate = update_slider(gcbo,rate_text, 0, 1.5, 0.005, ''Learning Rate: %1.3f'');');
rate_text = uicontrol('Style','Text','Position',[230 30 130 16], ...
		      'String',sprintf('Learning Rate: %1.3f',LearnRate));

momentum_slider = uicontrol('Style','Slider','Tag','momentum', ...
  'Position', [75 10 150 16], 'Value', Momentum, ...
  'SliderStep', [.005 0.1], ...
  'CallBack','Momentum = update_slider(gcbo,momentum_text,0, 1, 0.005, ''Momentum: %1.3f'');');
momentum_text = uicontrol('Style','Text','Position',[230 10 130 16], ...
		       'String', sprintf('Momentum: %1.3f',get(momentum_slider,'Value')));


Begin_button = uicontrol('Style','PushButton','Position',[10 70 60 18], ...
	'BackgroundColor',[.8 .8 0],'String','Begin', ...
	'CallBack','ErrorSurface');

run_button = uicontrol('Style','PushButton','Position',[10 50 60 18], ...
	'BackgroundColor',[.2 .8 .2],'String','Run', ...
	'CallBack','run_flag = Inf; optimize_mainloop');

step_button = uicontrol('Style','PushButton','Position',[10 30 60 18], ...
	'BackgroundColor',[.5 .5 1],'String','Step', ...
	'CallBack','run_flag = 1; optimize_mainloop');

stop_button = uicontrol('Style','PushButton','Position',[10 10 60 18], ...
	'BackgroundColor',[.8 .2 .2],'String','Stop', ...
	'CallBack','run_flag = 0; disp(''Stopped.'')');

method_menu = uicontrol('Style','Popup', ...
        'Position',[75 50 150 20], 'String', {'Gradient Descent','Line Search', ... 
		    'Conjugate Gradient'},'CallBack','dim_sliders');

H_edit = uicontrol('Style','edit','Position',[370 10 180 22], ...
		   'BackgroundColor',[.3 .7 1],'String',strcat('Hessian=',mat2str(Hessian)), ...
		   'CallBack','ErrorSurface');

reset_button = uicontrol('Style','PushButton','Position',[370 35 180 ...
		    22],'BackgroundColor',[1 .5 .5],'String','Reset to Defaults', ...
		    'CallBack','setup_defaults');



