%   Main loop

if t == 0,
  fprintf('Epoch %3d:  ',t);
  fprintf('TSS = %6.5f\n',TSS);
end

while run_flag > 0
  t = t+1;
  run_flag = run_flag - 1;
  prevW = Weights; prevTSS = TSS;
  
  if (TSS < 0.0000001)
    run_flag =0;
    fprintf('\nDone\n');
    break;
  end
  
  %Gradient of the Error function
  Error = Hessian*Weights';  
  old_dW = dW;
  old_d = d;
  old_g = g;
  g=Error';
  
  if get(method_menu,'Value') == 1 %Gradient Descent,
    dW = -  LearnRate *(Error')+ Momentum*old_dW;
  else
    if (get(method_menu,'Value') == 2) %Line Search
      d=-Error';
    elseif (get(method_menu,'Value') == 3) %Conjugate Gradient
      if old_d == 0
	d=-g;
      else
	beta = g*(g'-old_g')/(old_d*(g'-old_g'));
	d = -g+beta*old_d;
      end
    end
    d = d./sqrt(d*d');
    a = A; b = B; c = C;
    %find the minimum along the 'd' direction
    for j = 1:500,
      x = b -0.5*((b-a)^2*((Weights+b*d)*Hessian*(Weights'+b*d')- ...
			   (Weights+c*d)*Hessian*(Weights'+c*d'))- ...
		  (b-c)^2*((Weights+b*d)*Hessian*(Weights'+b*d')- ...
			   (Weights+a*d)*Hessian*(Weights'+a*d')))/ ...
	  ((b-a)*((Weights+b*d)*Hessian*(Weights'+b*d')- ...
		  (Weights+c*d)*Hessian*(Weights'+c*d'))- ...
	   (b-c)*((Weights+b*d)*Hessian*(Weights'+b*d')- ...
		  (Weights+a*d)*Hessian*(Weights'+a*d')));
      if x - b < 0.0000000001
	  break; 
      elseif x < b
	c = b;
      else
	a = b;
      end
      b = x;
    end
    dW =  x*d;        
  end
  Weights = Weights + dW;
  TSS = Weights*Hessian*Weights';

  subplot(axpat)
  plot([prevW(1,1) Weights(1,1)],[prevW(1,2) Weights(1,2)],'-m');
  subplot(axbowl);
  plot3([prevW(1,1) Weights(1,1)],[prevW(1,2) Weights(1,2)],[prevTSS TSS],'-m');
  plot3(Weights(1,1),Weights(1,2),TSS,'om');
  fprintf('Epoch %3d:  ',t);
  fprintf('TSS = %6.5f\n',TSS);
  pause(0.1)
   
end
