%Calculate the error surface and reset the simulation.

g = 0;
d = 0;
dW = 0;
t = 0;

%Get the Hessian from the edit window

Herror_flag = 0;
eval(get(H_edit,'String'),'Herror_flag = 1;');
if (Herror_flag == 1) || ... 
      ~ all(size(Hessian) == [2 2]) || ...
      (Hessian(1,2)~=Hessian(2,1))
  fprintf('Invalid Hessian (must be a symmetric 2x2 matrix).\n');
  fprintf('Setting Hessian to its default value.\n \n');
  Hessian = default_Hessian;
  set(H_edit,'String',strcat('Hessian=',mat2str(Hessian)));
  Herror_flag = 0;
elseif (min(eig(Hessian)) < 0)
  fprintf('Hessian = %s is not positive definite.\n',mat2str(Hessian));
  fprintf('Setting Hessian to its default value.\n \n');
  Hessian = default_Hessian;
  set(H_edit,'String',strcat('Hessian=',mat2str(Hessian)));
end
  
old_dW = 0;
InitWeights = [-0.5,-1];
Weights = InitWeights;

%   Calculate and plot the error surface
fprintf('Calculating and plotting the error surface...\n');
w0range = -1:0.05:1;
w1range = -1:0.05:1;
[xm,ym] = meshgrid(w0range,w1range);

zm = 0*xm;
W = Weights;
for i = 1:size(xm,1)
 for j = 1:size(ym,2)
  W(1,1:2) = [xm(i,j) ym(i,j)];
  zm(i,j) = W*Hessian*W';
 end
end

axpat=subplot(1,2,2); cla; hold on
axis square equal
contour(xm,ym,zm,contours,'c');
axis([-1 1 -1 1])

axbowl = subplot(1,2,1); cla;
contour3(xm,ym,zm,contours,'c');
hold on;
axis([w0range(1) w0range(end) w1range(1) w1range(end) ...
      0 1.5*zm(find(xm==InitWeights(1) & ym==InitWeights(2)))]);
view (-35,14);
grid off, box on
xlabel('w0'); ylabel('w1'); zlabel('Error'); title('Error Surface')
set(gca,'CameraViewAngleMode','manual')
rotate3d off, rotate3d on
prevW = Weights;
prevTSS = Weights*Hessian*Weights';
TSS = prevTSS;
plot3(prevW(1,1),prevW(1,2),prevTSS,'om');

disp('Done.')
