% S = EMSIGMASQ(J,MU_JD)
%  Estimates an initial sigma-squared value for unit j as the 
%  minimum distance between mu_j and the mu of any other unit.

function S = emsigmasq(J,Mu_jd)

  Nbumps = size(Mu_jd,1);

  if Nbumps > 1
    coords = ones(Nbumps,1) * Mu_jd(J,:);
    distvals = sum((Mu_jd-coords)'.^2);
    distvals(J) = Inf;
    S = min(distvals);
  else
    S = 1;
  end

