% EMSHOW -- display function for EM algorithm

function emshow(Mu_jd,SigmaSq_j,Patterns_nd)

  clf, whitebg(gcf,[0 0 0])
  set(gcf,'Color',[0 0 0])
  axis equal, hold on
  amin = min(Patterns_nd);
  amax = max(Patterns_nd);
  axis([amin(1) amax(1) amin(2) amax(2)])
  plot(Patterns_nd(:,1),Patterns_nd(:,2),'.r','MarkerSize',4)

  circpts = -pi:pi/20:pi;
  xcirc = cos(circpts);
  ycirc = sin(circpts);

  Sigma = sqrt(SigmaSq_j);
  for k = 1:length(Sigma)
    plot(xcirc*Sigma(k)+Mu_jd(k,1),ycirc*Sigma(k)+Mu_jd(k,2),'y')
  end

  drawnow
%  pause(1)