% EMGENERATE(D) -- generate a test dataset for EM algorithm.

function [B,Z] = emgenerate(D)

  if D==1
    d1 = randg2(100)*0.25 + ones(100,1)*[1 1.5];
    d2 = randg2(100)*0.25 + ones(100,1)*[2 0];
    d3 = randg2(100)*0.25 + ones(100,1)*[1 -1.5];
    B = 6;
    Z = [d1; d2; d3; -d1; -d2; -d3];
  elseif D==3
    d1=randg2(6000);
    mag = sqrt(sum(d1'.^2));
    B = 8;
    Z = d1(mag > 0.4 & mag < 1.0,:);
  elseif D==2
    d1 = randg2(1000)*.5;
    d2 = randg2(1500)*5 + 10;
    d3 = randg2(2000)*7 + 30;
    B = 3;
    Z = [d1; d2; d3];
  elseif D==4
    d1 = randg2(500)*20 + ones(500,1)*[50,0];
    d2 = randg2(200)*3 + ones(200,1)*[20,35];
    d3 = randg2(200)*3 + ones(200,1)*[10,5];
    B = 3;
    Z = [d1; d2; d3];
  else
    error('EmDataSet must between 1 and 4')
  end

