#define N 512

int x[N];
int y[N];
int z[N];

int a[N][N];
int b[N][N];
int c[N][N];

int A[N][N][N];
int B[N][N][N];
int C[N][N][N];

/*
 Loop Nest 1
 L0xd0af40(ptr)	S0xd0b0f0(ptr)	[<(3)]
 L0xd0b020(ptr)	S0xd0b0f0(ptr)	[>(-2)]
 S0xd0b0f0(ptr)	L0xd0af40(ptr)	[>(-3)]
 S0xd0b0f0(ptr)	L0xd0b020(ptr)	[<(2)]
 Matrix 1
 [<]
 */
void test0(int *ptr)
{
	unsigned i;
	for(i = 0; i < N; i++)
		*ptr++ = *(ptr+3) + *(ptr-2);
}

/* 
 Loop Nest 2
 L0xd09780(A)	S0xd09c50(A)	[>(-1)>(-1)=]
 L0xd09a70(A)	S0xd09c50(A)	[>(-1)=<(1)]
 S0xd09c50(A)	L0xd09780(A)	[<(1)<(1)=]
 S0xd09c50(A)	L0xd09a70(A)	[<(1)=>(-1)]
 Matrix 2
 [<<=]
 [<=>]
 */
void test1()
{
	unsigned i,j,k;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
			for(k = 0; k < N; k++)
			{
				A[i+1][j+1][k] = A[i][j][k] + A[i][j+1][k+1];
			}
}

/* 
 Loop Nest 3
 L0xd081b0(x)	S0xd08440(x)	[*>(-1)]
 L0xd082f0(x)	S0xd08440(x)	[*=]
 S0xd08440(x)	L0xd081b0(x)	[*<(1)]
 S0xd08440(x)	L0xd082f0(x)	[*=]
 Matrix 3
 [<<]
 [<=]
 [<>]
 [=<]
 [==] 
*/
void test2()
{
	unsigned i,j;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
		{
			x[j+1] = (x[j]+x[j+1])/2;
		}
}

/*
 Loop Nest 4
 L0xd04320(A)	S0xd046a0(A)	[>(-1)==]
 S0xd046a0(A)	L0xd04320(A)	[<(1)==]
 Matrix 4
 [<==]
 */
void test3()
{
	unsigned i,j,k;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
			for(k = 0; k < N; k++)
			{
				A[k][j][i] = A[k][j][i-1] + b[k][i];
			}
}

/*
 Loop Nest 5
 L0xd145e0(A)	S0xd14da0(A)	[>(-1)==]
 L0xd148d0(A)	S0xd14da0(A)	[>(-1)>(-1)=]
 L0xd14bc0(A)	S0xd14da0(A)	[=>(-1)=]
 S0xd14da0(A)	L0xd145e0(A)	[<(1)==]
 S0xd14da0(A)	L0xd148d0(A)	[<(1)<(1)=]
 S0xd14da0(A)	L0xd14bc0(A)	[=<(1)=]
 Matrix 5
 [<<=]
 [<==]
 [=<=]
 */
void test4()
{
	unsigned i,j,k;
	for(j = 0; j < N; j++)
		for(k = 0; k < N; k++)
	for(i = 0; i < N; i++)
			{
				A[i][j][k] = A[i][j-1][k] + A[i][j-1][k-1] + A[i][j][k-1];
			}
}

/*
 Loop Nest 6
 L0xd0d2f0(a)	S0xd0d650(a)	[>(-1)>(-1)]
 L0xd0d4e0(a)	S0xd0d650(a)	[=>(-1)]
 S0xd0d650(a)	L0xd0d2f0(a)	[<(1)<(1)]
 S0xd0d650(a)	L0xd0d4e0(a)	[=<(1)]
 Matrix 6
 [<<]
 [=<] 
*/
void test5()
{
	unsigned i,j;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
		{
			a[i+1][j+1] = a[i][j]+a[i+1][j];
		}
	
}

/*
 Loop Nest 7
 L0xd12980(c)	S0xd12e80(c)	[==*]
 S0xd12e80(c)	L0xd12980(c)	[==*]
 Matrix 7
 [==<]
 [===] 
 */
void test6()
{
	int i,j,k;
	
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
			for(k = 0; k < N; k++)
				c[i][j] += a[i][k]*b[k][j];
}

/*
 Loop Nest 8
 L0xd0bf00(a)	S0xd0c210(a)	[>(-1)>(-1)]
 S0xd0c210(a)	L0xd0bf00(a)	[<(1)<(1)]
 Matrix 8
 [<<]
 */
void test7()
{
	unsigned i,j;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
		{
			a[i+1][j+1] = a[i][j]+b[i][j];
		}
	
}

int X1,X2,X3;
/*
 Loop Nest 9
 L0xd05e20(A)	S0xd06040(A)	[>(-1)==]
 S0xd06040(A)	L0xd05e20(A)	[<(1)==]
 L0xd063b0(B)	S0xd065d0(B)	[==>(-1)]
 S0xd065d0(B)	L0xd063b0(B)	[==<(1)]
 L0xd069e0(C)	S0xd06c00(C)	[>(-1)>(-1)>(-1)]
 S0xd06c00(C)	L0xd069e0(C)	[<(1)<(1)<(1)]
 Matrix 9
 [<<<]
 [<==]
 [==<] 
 */
void test8()
{
	unsigned i,j,k;
	for(i = 0; i < N; i++)
		for(j = 0; j < N; j++)
			for(k = 0; k < N; k++)
			{
				A[i+1][j][k] = A[i][j][k] + X1;
				B[i][j][k+1] = B[i][j][k] + X2;
				C[i+1][j+1][k+1] = C[i][j][k] + X3;
			}
}

/*
 Loop Nest 10
 L0xd0ea20(A)	S0xd0eef0(A)	[=>(-1)>(-1)]
 L0xd0ed10(A)	S0xd0eef0(A)	[>(-1)=<(1)]
 S0xd0eef0(A)	L0xd0ea20(A)	[=<(1)<(1)]
 S0xd0eef0(A)	L0xd0ed10(A)	[<(1)=>(-1)]
 Matrix 10
 [<=>]
 [=<<] 
 */
void test9()
{
	unsigned i,j,k;
	for(i = 1; i < N; i++)
		for(j = 1; j < N; j++)
			for(k = 0; k < N; k++)
			{
				A[i][j][k+1] = A[i][j-1][k] + A[i-1][j][k+2];
			}
}

/*
 Loop Nest 11
 L0xd106a0(A)	S0xd111f0(A)	[=>(-1)=]
 L0xd10990(A)	S0xd111f0(A)	[>(-1)=>(-1)]
 L0xd10cd0(A)	S0xd111f0(A)	[=<(1)<(1)]
 L0xd11010(A)	S0xd111f0(A)	[>(-1)=<(1)]
 S0xd111f0(A)	L0xd106a0(A)	[=<(1)=]
 S0xd111f0(A)	L0xd10990(A)	[<(1)=<(1)]
 S0xd111f0(A)	L0xd10cd0(A)	[=>(-1)>(-1)]
 S0xd111f0(A)	L0xd11010(A)	[<(1)=>(-1)]
 Matrix 11
 [<=<]
 [<=>]
 [=<<]
 [=<=] 
*/ 
void test10()
{
	unsigned i,j,k;
	for(i = 2; i < N; i++)
		for(j = 2; j < N; j++)
			for(k = 2; k < N; k++)
			{
				A[i][j][k] = A[i][j-1][k] + A[i-1][j][k-1] + A[i][j+1][k+1] + A[i-1][j][k+1];
			}
}
