/* tomcatv.f -- translated by f2c (version 20030320).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    doublereal s1alt;
} zeit_;

#define zeit_1 zeit_

/* Table of constant values */

static integer c__1 = 1;

/* **************************************************************** */

/*     MESHGENERATION WITH THOMPSONS SOLVER, VECTORIZED VERSION */

/*     SET  N = 33, 65, 129 */

/*     DO  SCALAR AND VECTOR  RUNS */

/*     W.GENTZSCH   FH REGENSBURG   F.R.G. */

/* ***************************************************************** */

/* Main program */ int MAIN__(void)
{
    /* Format strings */
    static char fmt_1100[] = "(\0021\002,2x,\002*** 2-D ITERATION BEHAVIOR *"
	    "**\002,/)";
    static char fmt_1200[] = "(/,1x,\002IT   I   J   X-COR      I   J   Y-CO"
	    "R      I   J  \002,\002 X-RES      I   J   Y-RES\002,/)";
    static char fmt_1300[] = "(i3,i4,i4,e11.4,i4,i4,e11.4,i4,i4,e11.4,i4,i4,"
	    "e11.4)";

    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1;

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void), do_fio(integer *, char *, ftnlen);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    doublereal a, b, c__, d__[513][513], h__;
    integer i__, j, k, l, m;
    doublereal r__, x[513][513], y[513][
	    513], aa[513][513] , dd[513][513];
    integer im, jm, ll, ip, jp;
    doublereal qi, qj, rx[513][513], ry[513][513], xx, yx, xy, yy;
    integer i2m, j2m, i1p, j1p;
    doublereal abx, aby, rel, eps, rxm, rym, pxx, qxx, pyy, qyy, pxy, qxy, 
	    alfa, dmax__, dxcm, dycm;
    integer ixcm, lmax, jxcm, iycm, jycm, irxm, jrxm, irym, jrym;
    doublereal relfa;

    /* Fortran I/O blocks */
    static cilist io___11 = { 0, 6, 0, fmt_1100, 0 };
    static cilist io___12 = { 0, 6, 0, fmt_1200, 0 };
    static cilist io___58 = { 0, 6, 0, fmt_1300, 0 };



#define d___ref(a_1,a_2) d__[(a_1)-1][(a_2)-1]
#define x_ref(a_1,a_2) x[(a_1)-1][(a_2)-1]
#define y_ref(a_1,a_2) y[(a_1)-1][(a_2)-1]
#define aa_ref(a_1,a_2) aa[(a_1)-1][(a_2)-1]
#define dd_ref(a_1,a_2) dd[(a_1)-1][(a_2)-1]
#define rx_ref(a_1,a_2) rx[(a_1)-1][(a_2)-1]
#define ry_ref(a_1,a_2) ry[(a_1)-1][(a_2)-1]

    zeit_1.s1alt = 0.f;

    alfa = .1f;
    relfa = .98f;
    lmax = 100;
    eps = 5e-8f;
    h__ = .001953125f;
    rel = 2.f / relfa;

/*     INITIAL FIELDS FOR X(I,J) AND Y(I,J) WITH STRECH FACTOR ALFA */

    for (i__ = 1; i__ <= 513; ++i__) {
/* L4: */
	x_ref(i__, 1) = (real) (i__ - 1) / 512.f;
    }

    for (i__ = 1; i__ <= 513; ++i__) {
	x_ref(i__, 513) = x_ref(i__, 1);
	x_ref(1, i__) = 0.f;
	x_ref(513, i__) = 1.f;
	y_ref(i__, 1) = 0.f;
	y_ref(1, i__) = x_ref(i__, 1);
	y_ref(513, i__) = alfa * x_ref(i__, 1);
/* L1: */
    }
    for (i__ = 1; i__ <= 513; ++i__) {
/* L2: */
	y_ref(i__, 513) = (1.f - x_ref(i__, 1)) * y_ref(1, 513) + x_ref(i__, 
		1) * y_ref(513, 513);
    }
    for (j = 2; j <= 512; ++j) {
	for (i__ = 2; i__ <= 512; ++i__) {
	    x_ref(i__, j) = x_ref(i__, 1) * .9f;
	    y_ref(i__, j) = ((1.f - x_ref(i__, 1)) * y_ref(1, j) + x_ref(i__, 
		    1) * y_ref(513, j)) * .9f;
/* L3: */
	}
    }
/*     WRITE (6,1400) ((X(I,J),I=1,N),J=1,N) */
/*     WRITE (6,1400) ((Y(I,J),I=1,N),J=1,N) */
    s_wsfe(&io___11);
    e_wsfe();
    s_wsfe(&io___12);
    e_wsfe();

    i1p = 2;
    j1p = 2;
    i2m = 512;
    j2m = 512;


/*     START ITERATION LOOP 190 */

/*     CALL TIMEB(D1,D2,D3,D4,D5) */
    ll = 0;
L190:
    ixcm = 0;
    jxcm = 0;
    dxcm = 0.f;
    iycm = 0;
    jycm = 0;
    dycm = 0.f;
    irxm = 0;
    jrxm = 0;
    rxm = 0.f;
    irym = 0;
    jrym = 0;
    rym = 0.f;

/*     J-LOOP */

    m = 0;
    i__1 = j2m;
    for (j = j1p; j <= i__1; ++j) {
	jp = j + 1;
	jm = j - 1;
	++m;

/*     I-LOOP */

	i__2 = i2m;
	for (i__ = i1p; i__ <= i__2; ++i__) {
	    ip = i__ + 1;
	    im = i__ - 1;
	    xx = x_ref(ip, j) - x_ref(im, j);
	    yx = y_ref(ip, j) - y_ref(im, j);
	    xy = x_ref(i__, jp) - x_ref(i__, jm);
	    yy = y_ref(i__, jp) - y_ref(i__, jm);
	    a = (xy * xy + yy * yy) * .25f;
	    b = (xx * xx + yx * yx) * .25f;
	    c__ = (xx * xy + yx * yy) * .125f;
	    qi = 0.f;
	    qj = 0.f;
/*     QI = A*0.5 */
/*     QJ = B*0.5 */
	    aa_ref(i__, m) = -b;
	    dd_ref(i__, m) = b + b + a * rel;
	    pxx = x_ref(ip, j) - x_ref(i__, j) * 2.f + x_ref(im, j);
	    qxx = y_ref(ip, j) - y_ref(i__, j) * 2.f + y_ref(im, j);
	    pyy = x_ref(i__, jp) - x_ref(i__, j) * 2.f + x_ref(i__, jm);
	    qyy = y_ref(i__, jp) - y_ref(i__, j) * 2.f + y_ref(i__, jm);
	    pxy = x_ref(ip, jp) - x_ref(ip, jm) - x_ref(im, jp) + x_ref(im, 
		    jm);
	    qxy = y_ref(ip, jp) - y_ref(ip, jm) - y_ref(im, jp) + y_ref(im, 
		    jm);

/*     CALCULATE RESIDUALS ( EQUIVALENT TO RIGHT HAND SIDES OF EQUS.) */

	    rx_ref(i__, m) = a * pxx + b * pyy - c__ * pxy + xx * qi + xy * 
		    qj;
	    ry_ref(i__, m) = a * qxx + b * qyy - c__ * qxy + yx * qi + yy * 
		    qj;
/* L250: */
	}
/* L310: */
    }

/*     DETERMINE MAXIMUM VALUES OF RESIDUALS */

    i__1 = m;
    for (j = 1; j <= i__1; ++j) {
	i__2 = i2m;
	for (i__ = i1p; i__ <= i__2; ++i__) {
	    if ((d__1 = rx_ref(i__, j), abs(d__1)) < abs(rxm)) {
		goto L262;
	    }
	    rxm = rx_ref(i__, j);
	    irxm = i__;
	    jrxm = j;
L262:
	    if ((d__1 = ry_ref(i__, j), abs(d__1)) < abs(rym)) {
		goto L270;
	    }
	    rym = ry_ref(i__, j);
	    irym = i__;
	    jrym = j;
L270:
	    ;
	}
    }

/*     SOLVE TRIDIAGONAL SYSTEMS IN PARALLEL */

    if ((i__2 = m - 1) < 0) {
	goto L601;
    } else if (i__2 == 0) {
	goto L201;
    } else {
	goto L301;
    }
L201:
    i__2 = i2m;
    for (i__ = i1p; i__ <= i__2; ++i__) {
	rx_ref(i__, 1) = rx_ref(i__, 1) / dd_ref(i__, 1);
	ry_ref(i__, 1) = ry_ref(i__, 1) / dd_ref(i__, 1);
/* L102: */
    }
    goto L601;
L301:
    i__2 = i2m;
    for (i__ = i1p; i__ <= i__2; ++i__) {
	d___ref(i__, 1) = 1.f / dd_ref(i__, 1);
/* L103: */
    }
    i__2 = m;
    for (j = 2; j <= i__2; ++j) {
	i__1 = i2m;
	for (i__ = i1p; i__ <= i__1; ++i__) {
	    r__ = aa_ref(i__, j) * d___ref(i__, j - 1);
	    d___ref(i__, j) = 1.f / (dd_ref(i__, j) - aa_ref(i__, j - 1) * 
		    r__);
	    rx_ref(i__, j) = rx_ref(i__, j) - rx_ref(i__, j - 1) * r__;
	    ry_ref(i__, j) = ry_ref(i__, j) - ry_ref(i__, j - 1) * r__;
/* L401: */
	}
    }
    i__1 = i2m;
    for (i__ = i1p; i__ <= i__1; ++i__) {
	rx_ref(i__, m) = rx_ref(i__, m) * d___ref(i__, m);
	ry_ref(i__, m) = ry_ref(i__, m) * d___ref(i__, m);
/* L411: */
    }
    i__1 = m;
    for (j = 2; j <= i__1; ++j) {
	k = m - j + 1;
	i__2 = i2m;
	for (i__ = i1p; i__ <= i__2; ++i__) {
	    rx_ref(i__, k) = (rx_ref(i__, k) - aa_ref(i__, k) * rx_ref(i__, k 
		    + 1)) * d___ref(i__, k);
	    ry_ref(i__, k) = (ry_ref(i__, k) - aa_ref(i__, k) * ry_ref(i__, k 
		    + 1)) * d___ref(i__, k);
/* L501: */
	}
    }

/*     ADD CORRECTIONS */

    l = 0;
    i__2 = j2m;
    for (j = j1p; j <= i__2; ++j) {
	++l;
	i__1 = i2m;
	for (i__ = i1p; i__ <= i__1; ++i__) {
	    x_ref(i__, j) = x_ref(i__, j) + rx_ref(i__, l);
	    y_ref(i__, j) = y_ref(i__, j) + ry_ref(i__, l);
/* L290: */
	}
    }

/*     PREPARE OUTPUT OF CONVERGENCE BEHAVIOUR */

L601:
    ++ll;
    s_wsfe(&io___58);
    do_fio(&c__1, (char *)&ll, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&ixcm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&jxcm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&dxcm, (ftnlen)sizeof(doublereal));
    do_fio(&c__1, (char *)&iycm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&jycm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&dycm, (ftnlen)sizeof(doublereal));
    do_fio(&c__1, (char *)&irxm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&jrxm, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&rxm, (ftnlen)sizeof(doublereal));
    do_fio(&c__1, (char *)&irym, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&jrym, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&rym, (ftnlen)sizeof(doublereal));
    e_wsfe();
    abx = abs(rxm);
    aby = abs(rym);
    dmax__ = max(abx,aby);
    if (ll < lmax && dmax__ > eps) {
	goto L190;
    }

/*     CALL TIMEB(T1,T2,T3,T4,T5) */
/*     END OF ITERATION LOOP 190 */

/*     WRITE (6,1400) ((X(I,J),I=1,N),J=1,N) */
/*     WRITE (6,1400) ((Y(I,J),I=1,N),J=1,N) */
/*     WRITE(6,1414) T1 */
/* 1414 FORMAT(1X,' TIME = ',F12.6) */
/* L1400: */
    s_stop("", (ftnlen)0);
    return 0;
} /* MAIN__ */

#undef ry_ref
#undef rx_ref
#undef dd_ref
#undef aa_ref
#undef y_ref
#undef x_ref
#undef d___ref


