#ifndef POISSON_HH_V9IJOGAW
#define POISSON_HH_V9IJOGAW

#include "PixelBufferObject.hh"

/// Allocate memory for the poisson blending run.
void poissonAllocateMemory(
	PixelBufferObject & fg ///< [in] the foreground image
	);
	
/// Initialize a run of the poisson blending.
void poissonInit(
	uchar4 * bg,    ///< [in] the background image (restricted to foreground extent)
	uchar4 * fg,    ///< [in] the foreground image
	bool * mask     ///< [in] the fg/bg mask
	);
	
/// Display the poisson stuff.
void poissonDisplay();

#endif /* end of include guard: POISSON_HH_V9IJOGAW */
