#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// open gl
#include "open_gl.hh"

#include <cuda_runtime.h>

#include "window.hh"


/// The display callback.
void display()
{
	// run the cuda code
	runCuda();
	
	GLuint pbo = getPBO();
	GLuint textureID = getTextureID(); 
	const int image_width = 512;
	const int image_height = 512;
	
	// Create a texture from the buffer
	glBindBuffer(GL_PIXEL_UNPACK_BUFFER, pbo);

	// bind texture from PBO
	glBindTexture(GL_TEXTURE_2D, textureID);


	// Note: glTexSubImage2D will perform a format conversion if the
	// buffer is a different format from the texture. We created the
	// texture with format GL_RGBA8. In glTexSubImage2D we specified
	// GL_BGRA and GL_UNSIGNED_INT. This is a fast-path combination

	// Note: NULL indicates the data resides in device memory
	glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, image_width, image_height, 
		GL_RGBA, GL_UNSIGNED_BYTE, NULL);

	// Draw a single Quad with texture coordinates for each vertex.
	glBegin(GL_QUADS);
	glTexCoord2f(0.0f,1.0f); glVertex3f(0.0f,0.0f,0.0f);
	glTexCoord2f(0.0f,0.0f); glVertex3f(0.0f,1.0f,0.0f);
	glTexCoord2f(1.0f,0.0f); glVertex3f(1.0f,1.0f,0.0f);
	glTexCoord2f(1.0f,1.0f); glVertex3f(1.0f,0.0f,0.0f);
	glEnd();

	// Don't forget to swap the buffers!
	glutSwapBuffers();

	// if animFlag is true, then indicate the display needs to be redrawn
	glutPostRedisplay();
}

void reshape(int width, int height) {
	printf("reshape %i %i\n", width, height);
	glViewport(0, 0, width, height);
	glutPostRedisplay();
}

/// The keyboard callback
void keyboard(
	unsigned char key,	///< the key being pressed
	int x,				///< x coordinate of the mouse
	int y)				///< y coordinate of the mouse
{
	switch (key)
	{
		case 'q':
		case 'Q':
		case 27:
			cudaThreadExit();
			exit(0);
			break;
		default:
			break;
	}
}

/// The mouse callback
void mouse(
	int button, ///< which button was pressesd
	int state,	///< up or down
	int x,		///< x position
	int y)		///< y position
{
	return;
}

/// Mouse motion callback
void motion(
	int x,		///< x coordinate of mouse
	int y)		///< y coordinate of mouse
{
	return;
}

int main(int argc, char **argv) {
	createWindow(argc, argv);
	startApplication(argc, argv);
	return 0;
}
