#include <queue>
#include <list>
#include <cmath>
#include <iostream>
#include <algorithm>

#include "wiiLine.h"
#include "random_ArrivalTime.h"
#include "better_ArrivalTime.h"

static const int NumTotalBidders = 80;
static const int NumRandomBidders = 79;
static const int NumCycles = 5000;

using namespace std;

int main(void) {

  srand(time(0));
  
  vector<WiiWanter> wwVec(NumTotalBidders);
  vector<WiiArrivalTimeFunc> wwFuncVec(NumTotalBidders);
  vector<double> lastArrivalTimes(NumTotalBidders);

  for(int i = 0; i < NumRandomBidders; i++) {
    wwFuncVec[i] = &random_ArrivalTime;
    wwVec[i]._id = i;
    lastArrivalTimes[i] = StayHomeVal;
  }
  for(int i = NumRandomBidders; i < NumTotalBidders; i++) {
    wwFuncVec[i] = &better_ArrivalTime;
    wwVec[i]._id = i;
    lastArrivalTimes[i] = StayHomeVal;
  }

  //run this once for every week in the trial
  for(int week = 0; week < NumCycles; week++) {
    //making sure line is empty
    while(!wiiLine.empty()) {
      wiiLine.pop();
    }
    
    //getting all the wanters' arrival Times
    for(int wwNum = 0; wwNum < NumTotalBidders; wwNum++) {
      wwVec[wwNum]._oppCost = generalRandomFRng(OpportunityCostPerMinuteLowVal,
						OpportunityCostPerMinuteHighVal);
      wwVec[wwNum]._value = gaussianRandom(WiiValMean,WiiValStdDev);
      wwVec[wwNum]._arrivalTime = wwFuncVec[wwNum](wwVec[wwNum]._value,
						   wwVec[wwNum]._oppCost,
						   wwVec[wwNum]._money,
						   lastArrivalTimes);
      wiiLine.push(&(wwVec[wwNum]));
      //cout << wwNum << " " << wwVec[wwNum]._value << " " 
      //  << wwVec[wwNum]._oppCost << " " << wwVec[wwNum]._arrivalTime << endl;
    }

    //this is to get the arrival times for next week
    for(int wwNum = 0; wwNum < NumTotalBidders; wwNum++) {
      lastArrivalTimes[wwNum] = wwVec[wwNum]._arrivalTime;
    }
    sort(lastArrivalTimes.begin(),lastArrivalTimes.end(),greater<double>());

    //how many wiis were there this week?
    int numWiis = (int) round(gaussianRandom(WiisPerWeekMean,WiisPerWeekStdDev));

    //cout << "Number of wiis " << numWiis << endl;

    int wiiTicket = 0;
    for(int wwNum = 0; wwNum < NumTotalBidders; wwNum++) {
      WiiWanter* ww = wiiLine.top();
      wiiLine.pop();
      //first check that they didn't stay at home
      //if they did then we can break out of this loop
      //as everyone after them in the priority queue also stayed home
      //and they get zero profit
      if(ww->_arrivalTime == StayHomeVal) {
	break;
      } 
      if(wiiTicket < numWiis) {
	//first can they pay?
	if(ww->_money < WiiCost+CostOfTrans) {
	  //otherwise they still have to pay for transit and opCost
	  //and can go negative
	  ww->_money -= CostOfTrans+(ww->_arrivalTime * ww->_oppCost);
	  continue;
	}
	double moneyDiff = ww->_value - CostOfTrans - WiiCost - (ww->_arrivalTime * ww->_oppCost);
	ww->_money += moneyDiff; 
	ww->_totalWiis++;
	wiiTicket++;
	//cout << ww->_id << " got a Wii and made " << moneyDiff << " profit\n";
      } else {
	//in this case they went to the store but didn't get the wii
	ww->_money -= CostOfTrans+(ww->_arrivalTime*ww->_oppCost);
      }
    }
  }

  sort(wwVec.begin(), wwVec.end());
  
  //now we output
  for(int wwNum = 0; wwNum < NumTotalBidders; wwNum++) {
    cout << "Agent " << wwVec[wwNum]._id << " has $" << wwVec[wwNum]._money << " from buying " << wwVec[wwNum]._totalWiis << " Wiis " << endl;
  }
}
