#ifndef _GENERALINCLUDE_H_
#define _GENERALINCLUDE_H_

#include <cmath>
#include <iostream>
#include <vector>

inline static double uniform() {
  double x = (double)rand()/RAND_MAX;
  return(x);
}

inline static double generalRandomFRng(double low, double high) {
  double n = uniform();
  return(low+(high-low)*n);
}

double gaussianRandom(const double &m, const double &d)
{
  //double xt = uniform();

  //std::cout << xt << std::endl;

  static double t = 0.0;
  double x,v1,v2,r;
  if (t == 0.0)
    {
      do {
	v1 = 2.0 * uniform() - 1.0;
	v2 = 2.0 * uniform() - 1.0;
	r = v1 * v1 + v2 * v2;
      } while (r >= 1.0);
      
      r = sqrt((-2.0 * log(r)) / r);
      t = v2 * r;
      return (m + v1 * r * d);
    } else {
    x = t;
    t = 0.0;
    return (m + x * d);
  }
}

static const double StayHomeVal = -1.0;
static const double CostOfTrans = 40.0;

static const double WiisPerWeekMean = 20.0;
static const double WiisPerWeekStdDev = 5.0;

static const double WiiValMean = 500.0;
static const double WiiValStdDev = 75.0;

static const double OpportunityCostPerMinuteLowVal = .5;
static const double OpportunityCostPerMinuteHighVal = 1.0;

static const double InitialMoney = 10000.0;
static const double WiiCost = 250.0;

typedef double (*WiiArrivalTimeFunc)(double,double,double,std::vector<double>&);

#endif
