#define NULL 0

struct List {
  int head;
  struct List* tail;
};

typedef struct List list;

/*
 * INCORRECT version of cons
 * return pointer into stack frame of function
 */
list* cons_(int x, list* l) {
  list new;
  new.head = x;
  new.tail = l;
  return &new;
}

/*
 * Correct version of cons
 */
list* cons(int x, list* l) {
  list* new = (list *) malloc(sizeof(list));
  new->head = x;
  new->tail = l;
  return new;
}

int main () {
  list* l;

  /* outer cons overwrites head and tail of inner cons */
  l = cons_(1, cons_(2, NULL));
  printf("%d %d\n", l->head, l->tail->head);

  /* correctly generates linked list of length 2 */
  l = cons(1, cons(2, NULL));
  printf("%d %d\n", l->head, l->tail->head);
  exit(0);
}
