#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int
main(int argc,
     char *argv[])
{
    int fd, clientFD, optval, error, port, clientLen;
    int retVal = 0;
    unsigned char buf[4096];
    struct sockaddr_in addr, clientAddr;

    /* choose a port number > 1024 */
    port = 5555;

    /* create a TCP socket */
    fd = socket(AF_INET, SOCK_STREAM, 0);
    if(fd < 0) {
        printf("Unable to create a TCP socket (%d)\n", errno);
        return -1;
    }

    /* eliminates the "Address already in use" error from bind */
    optval = 1;
    error = setsockopt(fd, SOL_SOCKET, SO_REUSEADDR,
                       (const void *)&optval, sizeof(int));
    if(error < 0) {
        printf("Unable to set socket options (%d)\n", errno);
        goto cleanup;
    }

    /* bind the socket to a given port */
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = htonl(INADDR_ANY);
    addr.sin_port = htons((unsigned short)port);
    error = bind(fd, (struct sockaddr*)&addr, sizeof(addr));
    if(error < 0) {
        printf("Unable to bind to port %d (%d)\n", port, errno);
        goto cleanup;
    }

    /* listen for a connection */
    error = listen(fd, 128);
    if(error < 0) {
        printf("Unable to listen on socket (%d)\n", errno);
        goto cleanup;
    }

    /* accept an incoming connection */
    clientLen = sizeof(clientAddr);
    clientFD = accept(fd, (struct sockaddr *)&clientAddr, &clientLen);
    if(clientFD < 0) {
        printf("Error accepting connection on socket (%d)\n", errno);
        error = -1;
        goto cleanup;
    }

    /* loop reading until the socket is closed */
    while((error = read(clientFD, buf, 4096)) > 0) {
        buf[error] = 0; /* NULL-terminate the buffer */
        printf("%s", buf);
    } if(error < 0) {
        printf("Error reading data from socket (%d)\n", errno);
    }

    /* close the sockets and exit */
    close(clientFD);
 cleanup:
    close(fd);
    return error;
}
