#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

int
main(int argc,
     char *argv[])
{
    int fd, port, error;
    char *hostname, buf[4096];
    struct sockaddr_in addr;
    struct hostent* hp;

    /* read the hostname and port from the command line */
    hostname = argv[1];
    port = atol(argv[2]);

    /* create a TCP socket */
    fd = socket(AF_INET, SOCK_STREAM, 0);
    if(fd < 0) {
        printf("Unable to create a TCP socket (%d)\n", errno);
        return -1;
    }

    /* get the server's IP address using gethostbyname() */
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    hp = gethostbyname(hostname);
    if(hp == NULL){
        printf("Unable to resolve %s (%d)\n", hostname, errno);
        error = -1;
        goto cleanup;
    }
    memcpy(&addr.sin_addr.s_addr, hp->h_addr, hp->h_length);
    addr.sin_port = htons((unsigned short)port);

    /* connect to the server machine */
    error = connect(fd, (struct sockaddr*)&addr, sizeof(addr));
    if(error < 0) {
        printf("Unable to connect to server (%d)\n", errno);
        goto cleanup;
    }

    /* loop writing lines from the keyboard */
    while(fgets(buf, 4096, stdin) != NULL) {
        error = write(fd, buf, strlen(buf));
        if(error < 0) {
            printf("Error on write to server (%d)\n", errno);
            goto cleanup;
        }
    }

 cleanup:
    close(fd);
    return error;
}
