#include <signal.h>
#include <setjmp.h>
#include <stdio.h>
#include <unistd.h>

/* the global variable used for jumping during signal handling */
sigjmp_buf jmpEnv;

/* capture the signals USR1 and USR2 */
void
handleUSR(int signal)
{
    // jump back to the set point
    siglongjmp(jmpEnv, signal);
}

/* Create the signal handler, and then wait around for a signal */
int
main(int argc,
     char *argv[])
{
    int error, i = 0;

    // install the new handlers
    signal(SIGUSR1, handleUSR);
    signal(SIGUSR2, handleUSR);

    // print the pid of this process
    printf("pid: %d\n", getpid());

    // set the jump point
    error = sigsetjmp(jmpEnv, 1);
    if(error == 10) {
        // handle SIGUSR1
        printf("restarting\n");

        // XXX cleanup might go here

    } else if(error == 12) {
        // handle SIGUSR2
        printf("exiting\n");
        return 0;
    }

    // begin "processing"
    while(1) {
        sleep(2);
        printf("processing %d\n", i++);
    }

    // exit
    return 0;
}
