#include <stdio.h>
#include <stdlib.h>
#include "defs.h"

/* A struct used to compute averaged pixel value */
typedef struct {
  int red;
  int green;
  int blue;
  int num;
} pixel_sum;

/* Compute min and max of two integers, respectively */
static int min(int a, int b) { return (a < b ? a : b); }
static int max(int a, int b) { return (a > b ? a : b); }

/* Initializes all fields of sum to 0 */
static void initialize_pixel_sum(pixel_sum *sum) {
  sum->red = sum->green = sum->blue = 0;
  sum->num = 0;
  return;
}

/* Accumulates field values of p in corresponding fields of sum */
static void accumulate_sum(pixel_sum *sum, pixel p) {
  sum->red += (int) p.red;
  sum->green += (int) p.green;
  sum->blue += (int) p.blue;
  sum->num++;
  return;
}

/* Computes averaged pixel value in current_pixel */
static void assign_sum_to_pixel(pixel *current_pixel, pixel_sum sum) {
  current_pixel->red = (unsigned short) (sum.red/sum.num);
  current_pixel->green = (unsigned short) (sum.green/sum.num);
  current_pixel->blue = (unsigned short) (sum.blue/sum.num);
  return;
}

/* Returns averaged pixel value at (i,j) */
static pixel avg(int dim, int i, int j, pixel *src) {
  int ii, jj;
  pixel_sum sum;
  pixel current_pixel;

  initialize_pixel_sum(&sum);
  for(ii=max(i-1, 0); ii <= min(i+1, dim-1); ii++) 
    for(jj=max(j-1, 0); jj <= min(j+1, dim-1); jj++) 
      accumulate_sum(&sum, src[RIDX(ii,jj,dim)]);

  assign_sum_to_pixel(&current_pixel, sum);
 
  return current_pixel;
}


char naive_smooth_descr[] = "Naive Implementation of Smooth";
void naive_smooth(int dim, pixel *src, pixel *dst) {
  int i, j;

  for(i=0; i < dim; i++)
    for(j=0; j < dim; j++)
      dst[RIDX(i,j,dim)] = avg(dim, i, j, src);

  return;
}


char smooth_descr[] = "Currently set to: Naive Implementation of Smooth";
void smooth(int dim, pixel *src, pixel *dst) {
  naive_smooth(dim, src, dst);
}

/* Register functions for testing */
void register_smooth_functions() {
  add_smooth_function(&smooth, smooth_descr);
  add_smooth_function(&naive_smooth, naive_smooth_descr);
}

