#include <stdio.h>
#include <stdlib.h>
#include "defs.h"

team_t team = {
    /* Team name */
    "HarryBovik",
    /* First member full name */
    "Harry Bovik",
    /* First member email address */
    "bovik@nowhere.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};


/* The supplied naive version of rotate */
char naive_rotate_descr[] = "Naive Row-wise Traversal of src";
void naive_rotate(int dim, pixel *src, pixel *dst) {
  int i, j;

  for(i=0; i < dim; i++) {
    for(j=0; j < dim; j++) {
      dst[RIDX(dim-1-j,i,dim)] = src[RIDX(i,j,dim)];
    }
  }

  return;
}

char rotate_descr[] = "Currently set to: Naive Row-wise Traversal of src";
void rotate(int dim, pixel *src, pixel *dst) {
  naive_rotate(dim, src, dst);
}

/* Register different versions for testing */
void register_rotate_functions() {
  add_rotate_function(&rotate, rotate_descr);
  add_rotate_function(&naive_rotate, naive_rotate_descr);
}

