#
#  Perl daemon to keep watching a directory for handins, 
#  running a performance check on them when appropriate
#


## GLOBAL PARAMETERS
$g_passwd_file="../userdb/lab3.db";
$g_handin_dir="/home/httpd/handin/lab3_perfcheck";
$g_handin_arch="../handin/lab3_perfcheck_archives";
$g_sandbox_dir="../sandbox";
$g_run_interval = 50;
$g_history_file_cache= "../history/lab3.history";
$g_history_file_through= "../history/lab3.history2";
$_cachefiles = "../cachefiles/conversion.c";
$_throughfiles = "../throughfiles/conversion.c";

$compile_error = "Hi,
We tried to compile your file and found that
it generated some errors.  Sorry!";

$conversion_error = "Hi,
we ran your program and found that it
didn't convert all test matrices correctly. Sorry!";

## END GLOBAL PARAMETERS


# Main loop
while (1)
{
    dowork();
    sleep($g_run_interval);

}


#
# Main loop of the performance checker
#
sub dowork 

{
    my @files;
    my $thefile;
    my $filecount=0;

    opendir DIR, $g_handin_dir or die "Unable to read handin directory.";
    @files = readdir DIR;
    closedir DIR;

    foreach $thefile (@files)
    {
	if(($thefile ne ".") && ($thefile ne ".."))
	{
	    print "Found handin: $thefile\n";
	    $filecount++;

	    #setup the sandbox
	    setupsandbox("$g_handin_dir/$thefile");
	    
	    #run the test
	    doruntest();
	}
    }

    if($filecount>0)
    {
	#update the web page
#	dowebupdate();
    }


}

#
# Update the web page!
#
sub dowebupdate()
{


}



#
#
# Setup the sandbox, where we will test the program
#
#
sub setupsandbox()
{
    my ($myhandinfile) = @_;
    print "\n", $myhandinfile, "\n";
    # you should delete any files in the sandbox directory and
    # copy or link in any Makefiles or supporting files 
    # that are needed to run the test
    #
    # The filename of the student's handin is $myhandinfile.
    # You should copy it into the directory giving it the appropriate
    # name for the assignment
    

    # clean directory
    `rm -rf $g_sandbox_dir/*`;

    # chunk the filename into its prefix, the groupname, and its suffix
    # prefix is the time
    # group is the group name
    # suffix is the name of the c-file
   
    ($prefix, $group, $suffix) =split(/-/,$myhandinfile);
    print $prefix, " ", $group, " " , $suffix, "\n";
    #CHANGE: how do I get the lenght of a string?
    $time_stamp = substr($prefix, 34);
    print "timestam is $time_stamp\n";
 
    # copy all the files needed to compile into sandbox

    if($suffix eq "conversion.c"){

        # we want to do a cache perf check therefore copy all the files from 
        `cp ../cachefiles/* $g_sandbox_dir`;
        $current_history = $g_history_file_cache;

    }
    else {

        # copy all the files needed for a throughput test into the sandbox
        `cp ../throughfiles/* $g_sandbox_dir`;
        $current_history = $g_history_file_through;

    }

    # rename the handed in file and move into the sandbox
    #`mv $myhandinfile ../sandbox/$suffix`;
    `mv $myhandinfile $g_sandbox_dir/$suffix`;
}


#
#  Run tests on the stuff setup in the sandbox directory
#  
#
sub doruntest()
{
    # compile and run performance tests
    # you can use the saferun utility to redirect
    # output into a temporary file, and catch the
    # return value 
    # compile the driver program

    chdir($g_sandbox_dir);

    
    # check wether make successful

    if(system("make driver")){
         print "return of make: was error \n";
         mailgroup("$group", "213 Performance Check Results", $compile_error);
         exit();
    }
    else{
         print "return of make: was ok \n";
    }


    # CHANGE: have to do the following with saferun and create error messages for
    # timeouts and seg faults

    $errors = system("./saferun 40 error.txt  /usr/local/bin/perl eval_performance.pl");
    print "saferun returned with $error\n";
    #still needs to be done with saferun


    open(ERROR, "error.txt");
    $error_text = <ERROR>;

    if($error_text == -1){
       print "\n error in conversion\n";
    }
    if($error_text == -2){
       print "\nseg fault\n";
    }
    if($error_text > 0){

      # the run was succesful and $error_text contains the mean - send the file log
      print "The run was successful!\n";
      maillog($group, "213 Performance Check Results");

      #update history  CHANGE: is file tag really the file name as I assume?
      #yes, but use original name with timestamp

      open(HISTORY, ">>$current_history");
      $file_tag = $time_stamp . "-" . $group . "-" . $suffix;
      printf HISTORY "$group:$time_stamp:$file_tag:%.3f\n", $error_text;
      close(HISTORY);

      # give file the unique name file_tag and store in the archive
      `mv $suffix $g_handin_arch/$file_tag`;
       $file_tag = $file_tag . ".perf";
      `mv log $g_handin_arch/$file_tag`;
    }

    exit();
}

#
# Send email to both members of a group
#
# Usage: mailgroup(groupname, subject, messagebody)
#

sub mailgroup
{
    my ($groupname, $subject, $messagebody) = @_;

    my ($u,$p,$path, $member1, $member2);
    my $userid=$groupname;

    # open the text database
    unless(open(PFD,$g_passwd_file))
    {
        print "ERROR: Could not open user database: $g_passwd_file";
        return;
    }

    # first check if user exist

    while (<PFD>)
    {
        chomp;
        ($u,$p,$member1, $member2)=split(/:/,$_);
        if ($userid eq $u)
        {

            sendemail($member1, $subject, $messagebody);
            sendemail($member2, $subject, $messagebody);
            close(PFD);
            return 1;
        }
    }

    close(PFD);
    # oops, we didn't find that groupname!
    print "mailgroup: Unable to find group $groupname!\n";
    return 0;

}


sub maillog
{
    my ($groupname, $subject, $messagefile) = @_;

    my ($u,$p,$path, $member1, $member2);
    my $userid=$groupname;

    # open the text database
    unless(open(PFD,$g_passwd_file))
    {
        print "ERROR: Could not open user database: $g_passwd_file";
        return;
    }

    # first check if user exist

    while (<PFD>)
    {
        chomp;
        ($u,$p,$member1, $member2)=split(/:/,$_);
        if ($userid eq $u)
        {

            sendlog($member1, $subject);
            sendlog($member2, $subject);
            close(PFD);
            return 1;
        }
    }

    close(PFD);
    # oops, we didn't find that groupname!
    print "mailgroup: Unable to find group $groupname!\n";
    return 0;

}



# Send email to people
sub sendemail {
    my ($recepients, $subject, $text) = @_;


    print "Sending email to $recepients on \"$subject\".<br>";

    unless(open(MAILER, "|/bin/mail -s \"$subject\" $recepients"))
    {

        print "ERROR: Unable to access mailer.";
        return;
    }


    print MAILER $text;


    close(MAILER);


}

# Send log file to people
sub sendlog {
    my ($recepients, $subject, $text_file) = @_;


    print "Sending email to $recepients on \"$subject\".<br>";

    $command_string = "cat mail_header log  |/bin/mail -s \"$subject\" $recepients";
    print "this is the command \n $command_string\n";
    system "cat $g_sandbox_dir/mail_header $g_sandbox_dir/log  |/bin/mail -s \"$subject\" $recepients" ;
}


##--
# validate group name
# returns 1, if validated successfully
#         0 if  validation fails due to password or non existence of group
#
# Usage: validateGroup(groupname, grouppassword)
##--
sub validateGroup
{
    my $rc=0;
    my ($u,$p);
    my ($userid, $plain_pass) = @_;

    # open the text database
    unless(open(PFD,$g_passwd_file))
    {
        print "ERROR: Could not open user database\n";
        return;
    }
    
    # first check if user exist
    $g_upload_path='';
    while (<PFD>)
    {
        chomp;
        ($u,$p,$member1, $member2)=split(/:/,$_);
        if ($userid eq $u)
        {
            $rc=1;
            last;
        }
    }
    close(PFD);

    if (crypt($plain_pass,$p) ne $p)
    {
        $rc=0;
    }
    
    return ($rc);
}
