/*

  driver.c

  Driver program for conversion functions.

  DO NOT MODIFY ANYTHING ELSE IN THIS FILE

*/

#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include "defs.h"
#include "conversion.h"

extern team_t team; 

#define MICROSECONDS_PER_SECOND 1000000
#define BYTES_PER_MEGABYTE 1048576

/* Define block size for aligning data */
#define BSIZE 32
#define MAX_DIM 2048
static int data[2*MAX_DIM*MAX_DIM+BSIZE/sizeof(int)];
static  int *G, *COPY_OF_G;

static int test_dim_G[] = 
  {32, 64, 128, 256, 1024};

int clean_up_matrix[1000][1000];

void
clean_up_cache(){
  int i,j;
  for(i=0; i<1000; i++){
    for(j=0; j<1000; j++){
      clean_up_matrix[i][j] = 0;
    }
  }
}

void
create(int dim)
{
  int i, j;

  G = data;
  while ((unsigned) G % BSIZE)
    G++;
  COPY_OF_G = G + (dim*dim);


  // generate a random adjacency matrix and store
  // a copy of it in COPY_OF_G
  // we'll need the copy to verify later that G
  // was correctly converted

  for (i = 0; i < dim; i++){
    for (j = 0; j < dim; j++){
      if(i==j) {
        G[RIDX(i,j,dim)] = 1;
      }
      else{
        if((rand()%100) < 50) G[RIDX(i,j,dim)] = 1;
        else G[RIDX(i,j,dim)] = 0;
      }
      COPY_OF_G[RIDX(i,j,dim)] = G[RIDX(i,j,dim)];
   }
  }
}

int
verify(int *G,
       int *COPY_OF_G, int dim)
{
  int i, j;

  for (i = 0; i < dim; i++)
    for (j = 0; j < dim; j++){
      int G_entry = G[RIDX(j,i,dim)];
      int C_entry_1 = COPY_OF_G[RIDX(j,i,dim)];
      int C_entry_2 = COPY_OF_G[RIDX(i,j,dim)];

      if(G_entry != (C_entry_1||C_entry_2)){
         printf("-1\nerror in conversion: G[%d][%d] = %d, 
           correct value is %d\n", j, i, G_entry, (C_entry_1||C_entry_2));
        return 0;
      }
    }
 return 1;
}

void print(int *G, int dim){
  int i, j;

  for (i = 0; i < dim; i++){
    for (j = 0; j < dim; j++){
      printf("%d ", G[RIDX(i, j, dim)]);
    }
    printf("\n");
  }  
}

int
main(int argc, char *argv[])
{
  struct timeval t_start, t_end;
  double time, throughput;
  int test_num;
  int dim;
  FILE *THROUGH;

  if (argc < 2) {
    printf("insufficient arguments to %s: need to supply the number of the test case
            you want to run the test on\n",
	   basename(argv[0]));
    exit(EXIT_FAILURE);
  }

  srand(1000);
  test_num = atoi(argv[1]);
  if (test_num < 1 || test_num > sizeof(test_dim_G) / sizeof(int)) {
    printf("invalid argument to %s: need to supply a number between "
	   "1 and %d\n",
	   basename(argv[0]),
	   sizeof(test_dim_G) / sizeof(int));
    exit(EXIT_FAILURE);
  }
  test_num--;


  dim = test_dim_G[test_num];
  create(dim);
  clean_up_cache();
  time =0;

  gettimeofday(&t_start, NULL);
  good_throughput(G, dim);
  gettimeofday(&t_end, NULL);
  verify(G,COPY_OF_G, dim);

  time += (double)(((t_end.tv_sec - t_start.tv_sec)*MICROSECONDS_PER_SECOND) +
		  (t_end.tv_usec - t_start.tv_usec))/MICROSECONDS_PER_SECOND;

  create(dim);
  clean_up_cache();

  gettimeofday(&t_start, NULL);
  good_throughput(G, dim);
  gettimeofday(&t_end, NULL);

  time += (double)(((t_end.tv_sec - t_start.tv_sec)*MICROSECONDS_PER_SECOND) +
                   (t_end.tv_usec - t_start.tv_usec))/MICROSECONDS_PER_SECOND;



  time = time/2;
  throughput = ((dim * dim * sizeof(int)) / time )/(BYTES_PER_MEGABYTE);

  THROUGH = fopen("log", "a");
  fprintf(THROUGH, "Test %d Throughput  %f\n", (test_num + 1), throughput);

  exit(EXIT_SUCCESS);
}
