#include "defs.h"
#include "conversion.h"
#include<stdio.h>

/*
#define BLOCK_TRIANGLE8 1
#define BLOCK_TRIANGLE4 1
#define HYBRID 1

#define BLOCK_TRIANGLE8b 1
*/

#define BLOCK_TRIANGLE8x2


team_t team = {
    /* Team name to be displayed on webpage */
    "The Professor",
    /* First member full name */
    "Randy Bryant",
    /* First member email address */
    "Randy.Bryant@cs.cmu.edu",
    /* Second member full name (leave blank if none) */
    "",
    /* Second member email address (blank if none) */
    ""
};

#ifdef NAIVE
void
good_cache(int *G, int dim){
  int i, j;
  for (i = 0; i < dim; i++)
    for (j = 0; j < dim; j++)
      G[RIDX(j,i,dim)] = G[RIDX(j,i,dim)] || G[RIDX(i,j,dim)];
 
}  
#endif


#ifdef TRIANGLE
void
good_cache(int *G, int dim){
  int i, j;
  for (i = 0; i < dim; i++)
    for (j = 0; j < i; j++) {
      int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
      G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
    }
}  
#endif


#ifdef BLOCK_TRIANGLE8
void
good_cache_b8(int *G, int dim){
  int i, j;
  int ii, jj;
  for (ii = 0; ii < dim; ii+= 8) {
    /* Diagonal Blocks */
    for (i = ii; i < ii+8; i++)
      for (j = ii; j < i; j++) {
	int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
      }

    /* Other Blocks */
    for (jj = 0; jj < ii; jj+= 8)
      for (i = ii; i < ii+8; i++)
	for (j = jj; j < jj+8; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
  }
}  
#endif

#ifdef BLOCK_TRIANGLE4
void
good_cache_b4(int *G, int dim){
  int i, j;
  int ii, jj;
  for (ii = 0; ii < dim; ii+= 4) {
    /* Diagonal Blocks */
    for (i = ii; i < ii+4; i++)
      for (j = ii; j < i; j++) {
	int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
      }

    /* Other Blocks */
    for (jj = 0; jj < ii; jj+= 4)
      for (i = ii; i < ii+4; i++)
	for (j = jj; j < jj+4; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
  }
}  
#endif

#ifdef BLOCK_TRIANGLE8x2
void
good_cache(int *G, int dim){
  int i, j;
  int ii, jj;
  for (ii = 0; ii < dim; ii+= 8) {
    /* Diagonal Blocks */
    jj = ii;
    for (i = ii+7; i >= ii+1; i--)
      for (j = jj; j < i; j++) {
	int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
      }
  }

  /* Other Blocks */
  for (ii = 8; ii < dim; ii+= 8) {
    for (jj = 0; jj < ii; jj+= 8) {
      /* UL */
      for (i = ii; i < ii+4; i++)
	for (j = jj; j < jj+4; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
      /* UR */
      for (i = ii; i < ii+4; i++)
	for (j = jj+4; j < jj+8; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
      /* LR */
      for (i = ii+4; i < ii+8; i++)
	for (j = jj+4; j < jj+8; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
      /* LL */
      for (i = ii+4; i < ii+8; i++)
	for (j = jj; j < jj+4; j++) {
	  int adj = G[RIDX(j,i,dim)] | G[RIDX(i,j,dim)];
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)] = adj;
	}
    }
  }
}  
#endif

#ifdef BLOCK_TRIANGLE8b
/* This code is buggy */
void
good_cache(int *G, int dim){
  int i, j;
  int bi, bj;
  int ii, jj;
  int tbuf[8][8];
  for (ii = 0; ii < dim; ii+= 8) {
    /* Diagonal Blocks */
    jj = ii;
    /* Make transposed copy of block */
    for (bi = 0; bi < 8; bi++)
      for (bj = 0; bj < 8; bj++) {
	i = ii+bi;
	j = jj+bj;
	tbuf[bj][bi] = G[RIDX(i,j,dim)];
      }
    for (bi = 0; bi < 8; bi++)
      for (bj = 0; bj < 8; bj++) {
	G[RIDX(i,j,dim)] = G[RIDX(i,j,dim)] | G[RIDX(j,i,dim)]; /* tbuf[bi][bj]; */
      }

    /* Other Blocks */
    for (jj = 0; jj < ii; jj+= 8) {
      /* Make transposed copy of block jj, ii */
      for (bj = 0; bj < 8; bj++)
	for (bi = 0; bi < 8; bi++) {
	  j = jj+bj;
	  i = ii+bi;
	  tbuf[bi][bj] = G[RIDX(j,i,dim)];
	}
      /* Combine elements from block ii,jj */
      for (bi = 0; bi < 8; bi++)
	for (bj = 0; bj < 8; bj++) {
	  int adj;
	  i = ii+bi;
	  j = jj+bj;
	  adj = tbuf[bi][bj] | G[RIDX(i,j,dim)];
	  /* tbuf[bi][bj] = G[RIDX(i,j,dim)] = adj; */
	  adj = G[RIDX(i,j,dim)] | G[RIDX(j,i,dim)];
	  G[RIDX(i,j,dim)] = adj;
	}
      /* Copy transposed result back to block jj, ii */
      for (bj = 0; bj < 8; bj++)
	for (bi = 0; bi < 8; bi++) {
	  j = jj+bj;
	  i = ii+bi;
	  /* G[RIDX(j,i,dim)] = tbuf[bi][bj]; */
	  G[RIDX(j,i,dim)] = G[RIDX(i,j,dim)];
	}
    }
  }
}  
#endif

#ifdef HYBRID
void
good_cache(int *G, int dim){
  if (dim < 1024)
    good_cache_b8(G, dim);
  else
    good_cache_b4(G, dim);
}
#endif
