/*

  driver.c

  Driver program for conversion functions.

  DO NOT MODIFY ANYTHING ELSE IN THIS FILE

*/

#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include "defs.h"
#include "conversion.h"

extern team_t team; 

#define MICROSECONDS_PER_SECOND 1000000
#define BYTES_PER_MEGABYTE 1048576

/* Define block size for aligning data */
#define BSIZE 32
#define MAX_DIM 2048
static int data[2*MAX_DIM*MAX_DIM+BSIZE/sizeof(int)];
static  int *G, *COPY_OF_G;

static int test_dim_G[] = 
  {32, 64, 128, 56, 1024};

int clean_up_matrix[1000][1000];

void
clean_up_cache(){
  int i,j;
  for(i=0; i<1000; i++){
    for(j=0; j<1000; j++){
      clean_up_matrix[i][j] = 0;
    }
  }
}


void
create(int dim)
{
  int i, j;

  G = data;
  while ((unsigned) G % BSIZE)
    G++;
  COPY_OF_G = G + (dim*dim);


  // generate a random adjacency matrix and store
  // a copy of it in COPY_OF_G
  // we'll need the copy to verify later that G
  // was correctly converted

  for (i = 0; i < dim; i++){
    for (j = 0; j < dim; j++){
      if(i==j) {
        G[RIDX(i,j,dim)] = 1;
      }
      else{
        if((rand()%100) < 50) G[RIDX(i,j,dim)] = 1;
        else G[RIDX(i,j,dim)] = 0;
      }
      COPY_OF_G[RIDX(i,j,dim)] = G[RIDX(i,j,dim)];
   }
  }
}

int
verify(int *G,
       int *COPY_OF_G, int dim)
{
/*
  int i, j, k, sum;

  for (i = 0; i < dim; i++)
    for (j = 0; j < dim; j++){
      int G_entry = G[RIDX(j,i,dim)];
      int C_entry_1 = COPY_OF_G[RIDX(j,i,dim)];
      int C_entry_2 = COPY_OF_G[RIDX(i,j,dim)];
      if(G_entry != (C_entry_1||C_entry_2)){
        // printf("error in conversion: G[%d][%d] = %d, 
        //        correct value is %d\n", j, i, , G_entry, (C_entry_1||C_entry_2));
        exit(1);
      }
    }
 */  
}

void print(int *G, int dim){
  int i, j;

  for (i = 0; i < dim; i++){
    for (j = 0; j < dim; j++){
      printf("%d ", G[RIDX(i, j, dim)]);
    }
    printf("\n");
  }  
}

int
main(int argc, char *argv[])
{

  FILE *THROUGH;

  struct timeval t_start, t_end;
  double throughput;
  double time=0;
  int test_num;
  int dim;
  int i; 
  int num_rep = 10;
  double min=100000000;

  if (argc < 2) {
    printf("%s\n", team.team);
    exit(EXIT_SUCCESS);
  }      

/*
  if (argc < 3) {
    printf("insufficient arguments to %s: need to supply the number of the matrix
            you want to run the test on\n",
	   basename(argv[0]));
    exit(EXIT_FAILURE);
  }
*/

  // srand(time());
  srand(1000);
  test_num = atoi(argv[1]);
  if (test_num < 1 || test_num > sizeof(test_dim_G) / sizeof(int)) {
    printf("invalid argument to %s: need to supply a number between "
	   "1 and %d\n",
	   basename(argv[0]),
	   sizeof(test_dim_G) / sizeof(int));
    exit(EXIT_FAILURE);
  }
  test_num--;



  dim = test_dim_G[test_num];
  create(dim);
  clean_up_cache();

  switch(atoi(argv[2])){
  //switch(-3){


    case -3:
    gettimeofday(&t_start, NULL);
    good_cache_randy(G, dim);
    gettimeofday(&t_end, NULL);
    clean_up_cache();
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    break;    

    case -2:
    gettimeofday(&t_start, NULL);
    good_throughput(G, dim);
    gettimeofday(&t_end, NULL);
    clean_up_cache();
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    break;
                 
    case -1:
    gettimeofday(&t_start, NULL);
    row_convert(G, dim);
    gettimeofday(&t_end, NULL);
    clean_up_cache();
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    break;
   
    case 1:
    col_convert_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 2:
    gettimeofday(&t_start, NULL);
    good_through_unroll2(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;          

    case 3:
    gettimeofday(&t_start, NULL);
    col_convert_2_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 5:
    gettimeofday(&t_start, NULL);
    col_convert_unroll_2_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;


    case 6:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_2(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;


    case 7:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_2_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 8:
    gettimeofday(&t_start, NULL);
    col_convert_unroll_4(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 9:
    gettimeofday(&t_start, NULL);
    col_convert_unroll_4_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;


    case 10:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_4(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 11:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_4_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;


    case 12:
    gettimeofday(&t_start, NULL);
    col_convert_unroll_8(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 13:
    gettimeofday(&t_start, NULL);
    col_convert_unroll_8_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 14:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_8(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 15:
    gettimeofday(&t_start, NULL);
    col_convert_2_unroll_8_arith(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 16:
    gettimeofday(&t_start, NULL);
    quadrec_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 17:
    gettimeofday(&t_start, NULL);
    quadrec_transpose_arith(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;


    case 18:
    gettimeofday(&t_start, NULL);
    good_cache_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 19:
    gettimeofday(&t_start, NULL);
    good_cache_transpose_arith(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 20:
    gettimeofday(&t_start, NULL);
    good_throughput_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 21:
    gettimeofday(&t_start, NULL);
    row8_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 22:
    gettimeofday(&t_start, NULL);
    unroll8_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 23:
    gettimeofday(&t_start, NULL);
    unroll16_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 24:
    gettimeofday(&t_start, NULL);
    toggle16_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 25:
    gettimeofday(&t_start, NULL);
    unroll32_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 26:
    gettimeofday(&t_start, NULL);
    toggle32_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 27:
    gettimeofday(&t_start, NULL);
    unroll4_transpose(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 28:
    gettimeofday(&t_start, NULL);
    toggle16x2_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 29:
    gettimeofday(&t_start, NULL);
    toggle16_transpose(G, G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 30:
    gettimeofday(&t_start, NULL);
    toggle16x2_convert(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 31:
    gettimeofday(&t_start, NULL);
    toggle16_convert(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 32:
    gettimeofday(&t_start, NULL);
    good_cache_triangle(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 33:
    gettimeofday(&t_start, NULL);
    good_cache_b8(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 34:
    gettimeofday(&t_start, NULL);
    good_cache_b4(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 35:
    gettimeofday(&t_start, NULL);
    good_cache_8b(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();

    case 36:
    gettimeofday(&t_start, NULL);
    hybrid_cache(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 37:
    gettimeofday(&t_start, NULL);
    good_throughput_triangle(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 38:
    gettimeofday(&t_start, NULL);
    good_throughput_triangle2(G, dim);
    gettimeofday(&t_end, NULL);
    if(!verify(G,COPY_OF_G, dim)) printf("not verified!!!!!\n");
    clean_up_cache();
    break;

    case 39:
       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       good_throughput_unroll_4(G, dim);
       gettimeofday(&t_end, NULL);
    break;

    case 40:

       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       good_throughput_block(G, dim);
       gettimeofday(&t_end, NULL);
    break;

    case 41:
       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       hybrid_cache(G, dim);
       gettimeofday(&t_end, NULL);
    break;


    case 42:

       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       good_through_hybrid(G, dim);
       gettimeofday(&t_end, NULL);
    break;

    case 43:

       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       hybrid_cache_2(G, dim);
       gettimeofday(&t_end, NULL);
   break;
    case 44:
 
       create(dim);
       clean_up_cache();
       gettimeofday(&t_start, NULL);
       hybrid_block(G, dim);
       gettimeofday(&t_end, NULL);
   break;
                                 
    default:
    //printf("wrong function number\n");
 }
  
   // good_through(G, dim);

   // gettimeofday(&t_start, NULL);
   // good_cache_in_through(G, dim);
   // gettimeofday(&t_end, NULL);



  // verify(A, B, C);

/*
  if(atoi(argv[2]) < 39){
     time += (double)(((t_end.tv_sec - t_start.tv_sec)*MICROSECONDS_PER_SECOND) +
		  (t_end.tv_usec - t_start.tv_usec))/MICROSECONDS_PER_SECOND;
  }
  // printf("final time is %lf\n", time);
*/
     time = (double)(((t_end.tv_sec - t_start.tv_sec)*MICROSECONDS_PER_SECOND) +
                  (t_end.tv_usec - t_start.tv_usec))/MICROSECONDS_PER_SECOND;         
  throughput = ((dim * dim * sizeof(int)) / time )/(BYTES_PER_MEGABYTE);

   
   THROUGH = fopen("throughput_log", "w");
   fprintf(THROUGH, "Test %d Throughput  %f\n", (test_num + 1), throughput);
   // printf("Test %d Throughput  %f\n", (test_num + 1), throughput);

  exit(EXIT_SUCCESS);
}
