/*

  conversion.h

  DO NOT MODIFY ANTYHING IN THIS FILE

*/

#ifndef _CONVERSION_H_
#define _CONVERSION_H_

#include "defs.h"

/* Row major indexing of n X n matrix */
#define RIDX(i,j,n) ((i)*(n)+(j))        
#define COPY(daddr,saddr) *(daddr) = *(saddr) | *(daddr)
#define COPY_1(daddr,saddr) *(daddr) =  *(daddr) |  *(saddr)
#define COPY_2(saddr,daddr) *(daddr) =  *(daddr) |  *(saddr)
#define T_COPY(saddr,daddr) *(daddr)=*(saddr)= *(daddr) |  *(saddr)
 
/* Declaration of a transposition routine */
typedef void (*transposer)(int *, int *, int);
 
/* Add transposition routine to list of programs to measure */
void add_transposer(transposer f, char *description);
 
/* Called by main to register the set of transposition routines to benchmark */
void register_transposers(void);
 
void conversion(int *G, int dim);

void conversion_through(int *G, int dim);

#endif /* _CONVERSION_H_ */
