/* $Id$ */

/*
 *
 *  CS213 - Lab assignment 3
 *
 */

/// We have used segregated list with 2^n size
/// The list contains all free chunks with size <= the size given to the list

/// In this program, We assign sLFree (int* pointing to dseg_lo):
///    [Byte request size below is for Linux]
///
///    sLFree[0] for <=8 word blocks list
///    sLFree[1] for <=16 word blocks list
///    sLFree[2] for <=32 word blocks list
///    sLFree[3] for <=64 word blocks list
///    sLFree[4] for <=128 word blocks list
///    sLFree[5] for <=256 word blocks list
///    sLFree[6] for <=512 word blocks list
///    sLFree[7] for <=768 word blocks list
///    sLFree[8] for >768 word blocks list

/// Almost all sizes in this program are stated in terms of words

/// Free chunks are composed of the following:
/// Header(Size + Allocation Flag) + Previous Chunk's Address + 
/// Next Chunk's Address + Footer(Size + Allocation Flag)

/// Allocated chunks are composed of the following:
/// Header(Size + Allocation Flag) + User Data + Footer(Size + Allocation Flag)

/// To enforce 8 byte alignment, we always force even multiple of
/// 4 byte words to be allocated to fit the request
/// I also start the initial block of allocation at odd word address (x04 or x0C),
/// thus making the header take this address, and
/// the caller of the function will get next word address (x08 or x00)

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <unistd.h>

#include "memlib.h"
#include "malloc.h"

#define NONE -1

team_t team = {
  /* Team name to be displayed on webpage */
  "Most Spectacular Failure",
  /* First member full name */
  "Shinsuke Fukuda",
  /* First member email address */
  "sfukuda",
  /* Second member full name (leave blank if none) */
  "Edmund Wong",
  /* Second member email address (blank if none) */
  "edmund"
};

/// Finds the index to appropriate segregated list for a given size
int mm_findSLIndex(int numWordsNeeded)
{ 
  if (numWordsNeeded <= 8) return 0;
  else if (numWordsNeeded <= 16) return 1;
  else if (numWordsNeeded <= 32) return 2;
  else if (numWordsNeeded <= 64) return 3;
  else if (numWordsNeeded <= 128) return 4;
  else if (numWordsNeeded <= 256) return 5;
  else if (numWordsNeeded <= 512) return 6;
  else if (numWordsNeeded <= 768) return 7;
  else return 8;
}

/// Adds the chunk starting from offset sLOffset with size newSize
/// to appropriate free list, in descending order
void mm_addToFreeList(int sLOffset, int newSize) {
  int *sLHeap = (int *)dseg_lo;
  int sLIndex = mm_findSLIndex(newSize);

  /// If the size of new free block < 3,
  /// do not add it to the free list
  if (newSize <= 3) {
    if (newSize == 0)
      return;
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
  /// If the list that the chunk is being added is empty,
  /// then simply copy the data to it
  else if (sLHeap[sLIndex] == NONE) {
    sLHeap[sLIndex] = sLOffset;
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + 1] = sLIndex;
    sLHeap[sLOffset + 2] = NONE;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
  /// Otherwise, recursively search through the list to
  /// insert the chunk in descending size order
  else {
    int nextIndex = sLHeap[sLIndex];
    int nextSize = sLHeap[nextIndex] >> 1;
    int prevIndex = sLIndex;
     
    while (nextIndex != NONE && nextSize <= newSize) {
      prevIndex = nextIndex;
      nextIndex = sLHeap[nextIndex + 2];
      nextSize = sLHeap[nextIndex] >> 1;
    }
    if (prevIndex >= 9)
      sLHeap[prevIndex + 2] = sLOffset;
    else
      sLHeap[prevIndex] = sLOffset;
    if (nextIndex != NONE)
      sLHeap[nextIndex + 1] = sLOffset;
    sLHeap[sLOffset] = newSize << 1;
    sLHeap[sLOffset + 1] = prevIndex;
    sLHeap[sLOffset + 2] = nextIndex;
    sLHeap[sLOffset + newSize - 1] = newSize << 1;
  }
}

/// Pops the free chunk from the free list,
/// primarily when the block will be allocated
void mm_popFromFreeList(int prevIndex, int thisIndex) {
  int *sLHeap = (int *)dseg_lo;
  int nextIndex = sLHeap[thisIndex + 2];
  
  if (prevIndex < 9)
    sLHeap[prevIndex] = sLHeap[thisIndex + 2];
  else
    sLHeap[prevIndex + 2] = sLHeap[thisIndex + 2];

  if (nextIndex != NONE)
    sLHeap[nextIndex + 1] = prevIndex;
}

int mm_init()
{
  int i, flag = 0;
  int *sLHeap;

  /// Allocates one page heap to start things off
  if (mem_sbrk(mem_pagesize()) == NULL)
    return -1;

  /// Copy dseg_lo into local variable and
  /// initialize the segregated list
  sLHeap = (int *)dseg_lo;
  for (i = 0; i < 9; i++)
    sLHeap[i] = NONE;

  /// If dseg_lo is not 8 byte aligned,
  /// offset the initial index by 4
  if (((int)dseg_lo) & 7)
    flag = 1;

  mm_addToFreeList(9 + flag, 1024 - 9 - flag);
  return 0;
}

void *mm_malloc (size_t size)
{
  int numWordsNeeded, sLIndex, goToNextSize, i;
  int *sLHeap = (int *)dseg_lo;

  /// On LINUX or WIN32, wordsize = 4
  numWordsNeeded = ((unsigned)size >> 2) + 2;
  if (numWordsNeeded & 1)
    numWordsNeeded++;

  sLIndex = mm_findSLIndex(numWordsNeeded);
  
  /// If there is some chunk within the class that fit the request,
  /// then search within that class for a possible fit
  if (sLHeap[sLIndex] != NONE) {
    int thisIndex = sLHeap[sLIndex];
    int thisSize = sLHeap[thisIndex] >> 1;
    int prevIndex = sLIndex;
    
    while (thisIndex != NONE && thisSize < numWordsNeeded) {
      prevIndex = thisIndex;
      thisIndex = sLHeap[thisIndex + 2];
      thisSize = sLHeap[thisIndex] >> 1;
    }
    /// No chunk that fit this request is found within this block
    /// Re-search in bigger free chunk size list <-- One reason for slowdown?
    if (thisIndex == NONE)
      goToNextSize = 1;
    else {
      sLHeap[thisIndex] = (numWordsNeeded << 1) + 1;
      mm_popFromFreeList(prevIndex, thisIndex);
      mm_addToFreeList(thisIndex + numWordsNeeded, thisSize - numWordsNeeded);

      return &sLHeap[thisIndex + 1];
    }
  }

  /// If there is no free chunk in the smallest possible class,
  /// or if there was no chunk within that class that fit the request,
  /// search for the first available chunk in bigger size list
  if (sLHeap[sLIndex] == NONE || goToNextSize) {
    int index, sLOffset, freeSize;

    for (index = sLIndex + 1; index < 9 && sLHeap[index] == NONE; index++)
      ;
    if (index == 9) {
      /// No available chunk that fits this block has been found
      /// Expand the heap and combine with the top block
      int prevMemUse = mem_usage() >> 2;
      int *prevTopAdd = (int *)(((int)dseg_hi >> 2) << 2);
      int prevTopSize = (*prevTopAdd) >> 1;
      int newTopSize, topIndex;
      int actRequestSize, requestSize, requestPage;

      if ((*(prevTopAdd - prevTopSize + 1)) & 1)
	prevTopSize = 0;

      requestSize = numWordsNeeded - prevTopSize;
      requestPage = requestSize >> 10;
      if (requestSize & 0x3FF)
	requestPage++;
      actRequestSize = requestPage << 12;
	
      if (mem_sbrk(actRequestSize) == NULL)
	return NULL;
      
      newTopSize = prevTopSize + (mem_usage() >> 2) - prevMemUse;
      sLOffset = prevMemUse - prevTopSize + 1;
      freeSize = newTopSize;

      sLHeap[sLOffset] = newTopSize << 1;
      sLHeap[sLOffset + newTopSize - 1] = newTopSize << 1;

      if (prevTopSize >= 4)
	mm_popFromFreeList(sLHeap[sLOffset + 1], sLOffset);
    }
    else {
      sLOffset = sLHeap[index];
      freeSize = sLHeap[sLOffset] >> 1;
      mm_popFromFreeList(index, sLOffset);
    }

    /// Split the chunk into area for the request (Mark it as allocated)
    /// and the remainder; then pop the free chunk off from the free list
    sLHeap[sLOffset] = (numWordsNeeded << 1) + 1;

    /// Add the remainder to the free list
    mm_addToFreeList(sLOffset + numWordsNeeded, freeSize - numWordsNeeded);

    return &sLHeap[sLOffset + 1];
  }
  return NULL;
}

void mm_free (void *ptr)
{
  int sLOffset, thisSize; 
  int *sLHeap;
  //int prevSize = 0, nextSize = 0, nextIndex, prevIndex;
  
  /// Check that the given pointer lies within the heap and
  /// the seg list area
  // if ((int *)ptr < (int *)dseg_lo + 16 || (int *)ptr > (int *)dseg_hi)
  // return;
  
  /// Check whether this block is marked as allocated
  sLHeap = (int *)dseg_lo;
  sLOffset = (int)((int *)ptr - (int *)dseg_lo) - 1;
  if ((sLHeap[sLOffset] & 1) == 0)
    return;

  thisSize = sLHeap[sLOffset] >> 1;

  /// I gave up on implementing coalesce when I realized that
  /// this bogs the program down more than making it memory efficient

  /*
    /// Join the freed block with any adjacent free blocks,
 
    /// Coalesce with following block
    if (!(sLHeap[sLOffset + thisSize] & 1)) {
    nextSize = sLHeap[sLOffset + thisSize] >> 1;
    /// The block that follows is a <3 block,
    /// there might be additional free block beyond
    if (nextSize < 4) {
    thisSize = thisSize + nextSize;
    nextIndex = sLOffset + thisSize + nextSize;
    if (!(sLHeap[nextIndex] & 1) && ((sLHeap[nextIndex] >> 1) < 4))
    nextSize = nextSize + sLHeap[nextIndex] >> 1;
    }
    /// If not, check if <3 byte block follows this free chunk
    else if (!(sLHeap[sLOffset + nextSize] & 1) &&
    ((sLHeap[sLOffset + nextSize] >> 1) < 4))
    nextSize = nextSize + (sLHeap[sLOffset + nextSize] >> 1);
    }  

    /// Coalesce with previous block
    if (sLHeap[sLOffset - 1] & 1 == 0) {
    prevSize = sLHeap[sLOffset - 1] >> 1;
    /// The block that precedes is a <3 block,
    /// there might be additional free block beyond
    if (prevSize < 4) {
    prevIndex = sLOffset - prevSize;
    if (!(sLHeap[prevIndex] & 1) && ((sLHeap[prevIndex] >> 1) < 4))
    prevSize = prevSize + sLHeap[prevIndex] >> 1;      
    }
    /// If not, check if <3 byte block precedes this free chunk
    else if (!(sLHeap[sLOffset - prevSize - 1] & 1) &&
    ((sLHeap[sLOffset - prevSize - 1]) >> 1 < 4))
    prevSize = prevSize + (sLHeap[sLOffset - prevSize - 1] >> 1);
    }
    */

  /// Add the freed block to the free list
  mm_addToFreeList(sLOffset, thisSize);

  //mm_addToFreeList(sLOffset - prevSize, prevSize + thisSize + nextSize);
}
